/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.struct.AbstractStructArgumentIT;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.initializer.EnableFeature;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class StructArgumentIT
extends AbstractStructArgumentIT {
    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenPoint2DIsSentWithInvalidCrsIdV40(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt(5L).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"5\"");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenPoint2DIsSentWithInvalidCrsId(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt(5L).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"5\"", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22000", (GqlStatus)GqlStatusInfoCodes.STATUS_22000.getGqlStatus(), (String)"error: data exception", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N21: Unsupported coordinate reference system (CRS): code=5.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N21.getGqlStatus(), (String)"error: data exception - unsupported coordinate reference system. Unsupported coordinate reference system (CRS): code=5.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenPoint3DIsSentWithInvalidCrsIdV40(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt(1200L).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"1200\"");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenPoint3DIsSentWithInvalidCrsId(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt(1200L).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"1200\"", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22000", (GqlStatus)GqlStatusInfoCodes.STATUS_22000.getGqlStatus(), (String)"error: data exception", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N21: Unsupported coordinate reference system (CRS): code=1200.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N21.getGqlStatus(), (String)"error: data exception - unsupported coordinate reference system. Unsupported coordinate reference system (CRS): code=1200.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenPoint2DDimensionsDoNotMatchV40(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN_3D.getCode()).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian-3d, x=3.15, y=4.012)");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenPoint2DDimensionsDoNotMatch(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN_3D.getCode()).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian-3d, x=3.15, y=4.012)", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N24: Cannot construct a point from [3.15, 4.012].", (GqlStatus)GqlStatusInfoCodes.STATUS_22N24.getGqlStatus(), (String)"error: data exception - invalid coordinate arguments. Cannot construct a point from [3.15, 4.012].", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenPoint3DDimensionsDoNotMatchV40(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN.getCode()).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian, x=3.15, y=4.012, z=5.905)");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenPoint3DDimensionsDoNotMatch(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN.getCode()).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian, x=3.15, y=4.012, z=5.905)", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N24: Cannot construct a point from [3.15, 4.012, 5.905].", (GqlStatus)GqlStatusInfoCodes.STATUS_22N24.getGqlStatus(), (String)"error: data exception - invalid coordinate arguments. Cannot construct a point from [3.15, 4.012, 5.905].", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."))));
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenZonedDateTimeZoneIdIsNotKnownV40(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.DATE_TIME_ZONE_ID.getTag())).writeInt(0L).writeInt(0L).writeString("Europe/Marmaris"), "Illegal value for field \"params\": Illegal value for field \"tz_id\": Illegal zone identifier: \"Europe/Marmaris\"");
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenZonedDateTimeZoneIdIsNotKnown(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.DATE_TIME_ZONE_ID.getTag())).writeInt(0L).writeInt(0L).writeString("Europe/Marmaris"), "Illegal value for field \"params\": Illegal value for field \"tz_id\": Illegal zone identifier: \"Europe/Marmaris\"", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22NB5: Unknown time zone identifier 'Europe/Marmaris'.", (GqlStatus)GqlStatusInfoCodes.STATUS_22NB5.getGqlStatus(), (String)"error: data exception - unsupported time zone identifier. Unknown time zone identifier 'Europe/Marmaris'.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }
}

