/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import org.junit.jupiter.api.Timeout;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;

@TestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ResetLockedNodeIT {
    @Timeout(value=30L)
    @TransportTest
    void shouldErrorWhenResettingAConnectionWaitingOnALock(BoltWire wire, @Authenticated BoltTestConnection setupConnection, @Authenticated BoltTestConnection connectionA, @Authenticated BoltTestConnection connectionB) throws Exception {
        setupConnection.send(wire.run("CREATE (n {id: 123})")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)setupConnection).receivesSuccess(2);
        setupConnection.send(wire.goodbye()).close();
        MapValueBuilder paramsA = new MapValueBuilder();
        paramsA.add("currentId", (AnyValue)Values.intValue((int)123));
        paramsA.add("newId", (AnyValue)Values.intValue((int)456));
        MapValueBuilder paramsB = new MapValueBuilder();
        paramsB.add("currentId", (AnyValue)Values.intValue((int)123));
        paramsB.add("newId", (AnyValue)Values.intValue((int)789));
        connectionA.send(wire.begin()).send(wire.run("MATCH (n {id: $currentId}) SET n.id = $newId", paramsA.build())).send(wire.pull(100L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connectionA).receivesSuccess(3);
        connectionB.send(wire.run("MATCH (n {id: $currentId}) SET n.id = $newId", paramsB.build())).send(wire.pull(100L));
        Thread.sleep(300L);
        connectionB.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connectionB).receivesFailureV40(new Status[]{Status.Transaction.LockClientStopped}).receivesIgnored().receivesSuccess();
        connectionA.send(wire.commit());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connectionA).receivesSuccess();
    }
}

