/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.time.Duration;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class ResetMessageIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout, Duration.ofSeconds(5L));
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes, ByteUnit.kibiBytes((long)1L));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=1))
    void shouldFailAResetWhenInUnauthenticatedState(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=1))
    void shouldFailAResetWhenInAuthenticationState(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=1))
    void shouldResetToReadyStateWhenAuthenticated(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=0))
    void shouldResetToReadyStateWhenAuthenticatedLegacy(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=0))
    void shouldFailAResetWhenInUnauthenticatedStateLegacy(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
    }
}

