/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TransactionManagerCleanupIT {
    @Inject
    private Neo4jWithSocket server;

    @ProtocolTest
    void shouldIncreaseAndDecreaseTxCount(BoltWire wire, @Authenticated BoltTestConnection connection) throws IOException {
        TransactionManager txManager = ServerUtil.resolveDependency(this.server, TransactionManager.class);
        Assertions.assertThat((int)txManager.getTransactionCount()).isEqualTo(0);
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        Assertions.assertThat((int)txManager.getTransactionCount()).isEqualTo(1);
        connection.send(wire.rollback());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        Assertions.assertThat((int)txManager.getTransactionCount()).isEqualTo(0);
    }
}

