/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.streaming;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.initializer.EnableFeature;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltV44Wire;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.UnexpectedTypeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.testing.PackstreamBufAssertions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class StreamingIT {
    @ProtocolTest
    void shouldStreamWhenStatementIdNotProvided(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("UNWIND range(30, 40) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(5L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)30L)}).receivesRecord(new AnyValue[]{Values.longValue((long)31L)}).receivesRecord(new AnyValue[]{Values.longValue((long)32L)}).receivesRecord(new AnyValue[]{Values.longValue((long)33L)}).receivesRecord(new AnyValue[]{Values.longValue((long)34L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(2L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)35L)}).receivesRecord(new AnyValue[]{Values.longValue((long)36L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(3L, 0L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)37L)}).receivesRecord(new AnyValue[]{Values.longValue((long)38L)}).receivesRecord(new AnyValue[]{Values.longValue((long)39L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(10L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)40L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
        connection.send(wire.rollback());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldDiscardNResults(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("UNWIND range(30, 40) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(5L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)30L)}).receivesRecord(new AnyValue[]{Values.longValue((long)31L)}).receivesRecord(new AnyValue[]{Values.longValue((long)32L)}).receivesRecord(new AnyValue[]{Values.longValue((long)33L)}).receivesRecord(new AnyValue[]{Values.longValue((long)34L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.discard(2L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(3L, 0L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)37L)}).receivesRecord(new AnyValue[]{Values.longValue((long)38L)}).receivesRecord(new AnyValue[]{Values.longValue((long)39L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.discard(10L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
        connection.send(wire.rollback());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldSendAndReceiveStatementIds(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("UNWIND range(1, 10) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(3L, 0L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesRecord(new AnyValue[]{Values.longValue((long)2L)}).receivesRecord(new AnyValue[]{Values.longValue((long)3L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.run("UNWIND range(11, 20) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)1L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(2L, 1L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)11L)}).receivesRecord(new AnyValue[]{Values.longValue((long)12L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.run("UNWIND range(21, 30) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)2L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(4L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)21L)}).receivesRecord(new AnyValue[]{Values.longValue((long)22L)}).receivesRecord(new AnyValue[]{Values.longValue((long)23L)}).receivesRecord(new AnyValue[]{Values.longValue((long)24L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.run("UNWIND range(31, 40) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)3L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(1L, 3L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)31L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(2L, 0L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)4L)}).receivesRecord(new AnyValue[]{Values.longValue((long)5L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"has_more", (Object)true));
        connection.send(wire.pull(9L, 3L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecord(new AnyValue[]{Values.longValue((long)32L)}).receivesRecord(new AnyValue[]{Values.longValue((long)33L)}).receivesRecord(new AnyValue[]{Values.longValue((long)34L)}).receivesRecord(new AnyValue[]{Values.longValue((long)35L)}).receivesRecord(new AnyValue[]{Values.longValue((long)36L)}).receivesRecord(new AnyValue[]{Values.longValue((long)37L)}).receivesRecord(new AnyValue[]{Values.longValue((long)38L)}).receivesRecord(new AnyValue[]{Values.longValue((long)39L)}).receivesRecord(new AnyValue[]{Values.longValue((long)40L)}).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).doesNotContainKey((Object)"has_more"));
        connection.send(wire.commit());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldAcceptTransactionType(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin(x -> x.withDatabase("neo4j").withTransactionType("implicit"))).send(wire.run("RETURN 1")).send(wire.pull()).send(wire.commit()).send(wire.begin(x -> x.withDatabase("neo4j").withTransactionType("nonsense"))).send(wire.run("RETURN 1")).send(wire.pull()).send(wire.commit());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess().receivesSuccess().receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess().receivesSuccess();
    }

    @ProtocolTest
    void shouldReturnDatabaseNameOnCompletionViaPull(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("UNWIND range(1, 10) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.pull(5L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccessAfterRecords(meta -> Assertions.assertThat((Map)meta).doesNotContainKeys((Object[])new String[]{"db", "t_last"}));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccessAfterRecords(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"db", (Object)"neo4j")).containsKey((Object)"t_last"));
        connection.send(wire.rollback());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldReturnDatabaseNameOnCompletionViaDiscard(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("UNWIND range(1, 10) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"qid", (Object)0L)).containsKeys((Object[])new String[]{"fields", "t_first"}));
        connection.send(wire.discard(5L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccessAfterRecords(meta -> Assertions.assertThat((Map)meta).doesNotContainKeys((Object[])new String[]{"db", "t_last"}));
        connection.send(wire.discard());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccessAfterRecords(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"db", (Object)"neo4j")).containsKey((Object)"t_last"));
        connection.send(wire.rollback());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    private static void assertElementIdNode(PackstreamBuf buf, long nodeId, String label, Consumer<Map<String, Object>> propertyAssertions) {
        PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsStruct(78, 4L).containsInt(nodeId).containsList(labels -> Assertions.assertThat((List)labels).containsExactly(new Object[]{label})).containsMap(propertyAssertions).containsString(elementId -> Assertions.assertThat((String)elementId).isNotBlank());
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=0))
    void shouldReturnElementIdForNodes(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (m:Movie{title:\"The Matrix\"}) RETURN m")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).satisfies(new ThrowingConsumer[]{buf -> StreamingIT.assertElementIdNode(buf, 0L, "Movie", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"title", (Object)"The Matrix"))})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    private static void assertElementIdRelationship(PackstreamBuf buf, Consumer<PackstreamBuf> legacyNodeIdAssertions, Consumer<PackstreamBuf> nodeIdAssertions) {
        ((PackstreamBufAssertions)PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsAInt().satisfies(new Consumer[]{legacyNodeIdAssertions})).containsString("PLAYED_IN").containsMap(properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"year", (Object)2021L)).containsString(elementId -> Assertions.assertThat((String)elementId).isNotBlank()).satisfies(new Consumer[]{nodeIdAssertions});
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=0))
    void shouldReturnElementIdForRelationships(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (:Actor{name: \"Greg\"})-[r:PLAYED_IN{year: 2021}]->(:Movie{title:\"The Matrix\"}) RETURN r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(82, 8L).satisfies(new ThrowingConsumer[]{buf -> StreamingIT.assertElementIdRelationship(buf, b -> PackstreamBufAssertions.assertThat((PackstreamBuf)b).containsInt(0L).containsInt(1L), b -> PackstreamBufAssertions.assertThat((PackstreamBuf)b).containsString(startNodeElementId -> Assertions.assertThat((String)startNodeElementId).isNotBlank()).containsString(endNodeElementId -> Assertions.assertThat((String)endNodeElementId).isNotBlank()))})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=0))
    void shouldReturnElementIdForPaths(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE p=(:Actor{name: \"Greg\"})-[:PLAYED_IN{year: 2021}]->(:Movie{title:\"The Matrix\"}) RETURN p")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)((PackstreamBufAssertions)((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(80, 3L).containsListHeader(2L).satisfies(new ThrowingConsumer[]{buf -> StreamingIT.assertElementIdNode(buf, 0L, "Actor", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"name", (Object)"Greg"))})).satisfies(new ThrowingConsumer[]{buf -> StreamingIT.assertElementIdNode(buf, 1L, "Movie", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"title", (Object)"The Matrix"))})).containsListHeader(1L).containsStruct(114, 4L).satisfies(new ThrowingConsumer[]{buf -> StreamingIT.assertElementIdRelationship(buf, b -> {}, b -> {})})).containsList(indices -> Assertions.assertThat((List)indices).containsExactly(new Object[]{1L, 1L})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=0))
    void shouldNotNegotiateUTCPatch(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        wire.enable(new Feature[]{Feature.UTC_DATETIME});
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).doesNotContainKey((Object)"patch_bolt"));
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    void shouldAcceptUTCOffsetDateTimes(BoltWire wire, @Authenticated BoltTestConnection connection) {
        DateTimeValue input = DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(1995, 6, 14, 12, 50, 35, 556000000, ZoneOffset.ofHours(1)));
        MapValueBuilder params = new MapValueBuilder();
        params.add("input", (AnyValue)input);
        connection.send(wire.run("RETURN $input", params.build())).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(73, 3L).containsInt(803130635L).containsInt(556000000L).containsInt(3600L).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    void shouldAcceptUTCZoneDateTimes(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("RETURN datetime('1995-06-14T12:50:35.556+02:00[Europe/Berlin]')")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(105, 3L).containsInt(803127035L).containsInt(556000000L).containsString("Europe/Berlin").asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldRejectLegacyOffsetDatesWhenUTCIsAvailableV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        if (wire.getProtocolVersion().major() >= 5) {
            wire = new BoltV44Wire();
        } else {
            wire.disable(new Feature[]{Feature.UTC_DATETIME});
        }
        DateTimeValue input = DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(1995, 6, 14, 12, 50, 35, 556000000, ZoneOffset.ofHours(1)));
        MapValueBuilder params = new MapValueBuilder();
        params.add("input", (AnyValue)input);
        connection.send(wire.run("RETURN $input", params.build()));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40(new Status[]{Status.Request.Invalid});
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldRejectLegacyOffsetDatesWhenUTCIsAvailable(@Authenticated BoltTestConnection connection) {
        BoltV44Wire wire = new BoltV44Wire();
        DateTimeValue input = DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(1995, 6, 14, 12, 50, 35, 556000000, ZoneOffset.ofHours(1)));
        MapValueBuilder params = new MapValueBuilder();
        params.add("input", (AnyValue)input);
        connection.send(wire.run("RETURN $input", params.build()));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x46", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N00: The provided value is unsupported and cannot be processed.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), (String)"error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N97: Unexpected struct tag: 0x46.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N97.getGqlStatus(), (String)"error: data exception - unexpected struct tag. Unexpected struct tag: 0x46.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    private static void assertUniqueNodeIdsReturned(PackstreamBuf buf) {
        ArrayList<Long> seenNode = new ArrayList<Long>();
        for (int i = 0; i < 5; ++i) {
            try {
                Assertions.assertThat((boolean)seenNode.add(StreamingIT.extractNodeId(buf))).isTrue();
                continue;
            }
            catch (UnexpectedTypeException e) {
                org.junit.jupiter.api.Assertions.fail((Throwable)e);
            }
        }
    }

    private static long extractNodeId(PackstreamBuf buf) throws UnexpectedTypeException {
        PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsStruct(78, 4L);
        long nodeId = buf.readInt();
        PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsList(label -> Assertions.assertThat((List)label).isEmpty()).containsMap(propMap -> Assertions.assertThat((Map)propMap).isEmpty()).containsString(elementId -> Assertions.assertThat((String)elementId).isNotBlank());
        return nodeId;
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4)})
    void shouldReturnUniqueNodeIds(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (a), (b), (c), (d), (e) RETURN a,b,c,d,e")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(5L).satisfies(new ThrowingConsumer[]{StreamingIT::assertUniqueNodeIdsReturned})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }
}

