/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.initializer;

import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.connection.initializer.AbstractNegotiatingConnectionInitializer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.error.BoltTestClientException;
import org.neo4j.bolt.testing.messages.BoltWire;

public final class NegotiateConnectionInitializer
extends AbstractNegotiatingConnectionInitializer {
    @Override
    public void initialize(ExtensionContext extensionContext, ParameterContext context, BoltWire wire, BoltTestConnection connection) throws ParameterResolutionException {
        if (!wire.supportsLogonMessage()) {
            if (!context.isAnnotated(Authenticated.class)) {
                throw new UnsupportedOperationException("Cannot enter AUTHENTICATION stage via negotiation message in protocol version " + String.valueOf(wire.getProtocolVersion()));
            }
            return;
        }
        try {
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> this.assertNegotiatedFeatures(wire, (Map<String, Object>)meta));
        }
        catch (AssertionError | BoltTestClientException ex) {
            throw new ParameterResolutionException("Failed to authenticate connection", (Throwable)ex);
        }
    }
}

