/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.handler;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.neo4j.bolt.test.extension.error.TestRetryException;
import org.neo4j.bolt.test.extension.store.RetryInfo;

public abstract class AbstractRetryingTestExecutionExceptionHandler
implements TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        RetryInfo info = RetryInfo.getOrCreate(context, () -> this.createRetryInfo(context, throwable));
        if (info.mayRetry() && this.isRetryable(context, info, throwable)) {
            info = info.increment();
            info.publish(context);
            throw new TestRetryException(info, this.getMessage(context, info, throwable), throwable);
        }
        throw throwable;
    }

    protected RetryInfo createRetryInfo(ExtensionContext context, Throwable throwable) {
        return new RetryInfo(0, 5);
    }

    protected abstract String getMessage(ExtensionContext var1, RetryInfo var2, Throwable var3);

    protected abstract boolean isRetryable(ExtensionContext var1, RetryInfo var2, Throwable var3);

    static boolean hasDirectCause(Class<? extends Throwable> type, Throwable ex) {
        if (type.isInstance(ex)) {
            return true;
        }
        Throwable current = ex;
        do {
            Throwable cause;
            if (!(current instanceof AssertionError) || !type.isInstance(cause = current.getCause())) continue;
            return true;
        } while ((current = current.getCause()) != null);
        return false;
    }
}

