/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.handler;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.test.extension.handler.AbstractRetryingTestExecutionExceptionHandler;
import org.neo4j.bolt.test.extension.store.RetryInfo;
import org.neo4j.bolt.testing.client.error.BoltTestClientConnectionTimeoutException;
import org.neo4j.bolt.testing.client.error.BoltTestClientReadTimeoutException;
import org.neo4j.bolt.testing.client.error.BoltTestClientTimeoutException;
import org.neo4j.bolt.testing.client.error.BoltTestClientWriteTimeoutException;

public class ConnectionTimeoutRetryHandler
extends AbstractRetryingTestExecutionExceptionHandler {
    @Override
    protected String getMessage(ExtensionContext context, RetryInfo info, Throwable throwable) {
        if (throwable instanceof BoltTestClientConnectionTimeoutException) {
            return "Connection timeout - Database has gone away or failed to start up";
        }
        if (throwable instanceof BoltTestClientReadTimeoutException) {
            return "Read timeout - Database has gone away or locked up";
        }
        if (throwable instanceof BoltTestClientWriteTimeoutException) {
            return "Write timeout - Database has gone away or locked up";
        }
        return "Operation timeout - Database has gone away or locked up";
    }

    @Override
    protected boolean isRetryable(ExtensionContext context, RetryInfo info, Throwable cause) {
        return ConnectionTimeoutRetryHandler.hasDirectCause(BoltTestClientTimeoutException.class, cause);
    }
}

