/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.store;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;

public record RetryInfo(int count, int max) {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{RetryInfo.class});

    public static RetryInfo getOrCreate(ExtensionContext context, Supplier<RetryInfo> supplier) {
        Method method = context.getRequiredTestMethod();
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        return (RetryInfo)store.getOrComputeIfAbsent((Object)method, key -> (RetryInfo)supplier.get());
    }

    public void publish(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)method, (Object)this);
    }

    public boolean mayRetry() {
        if (this.max == 0) {
            return true;
        }
        return this.count + 1 <= this.max;
    }

    public RetryInfo increment() {
        return new RetryInfo(this.count + 1, this.max);
    }

    @Override
    public String toString() {
        return this.count + " / " + this.max;
    }
}

