/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.wire.selector;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.wire.selector.BoltWireSelector;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.util.AnnotationUtil;

public class FilteredBoltWireSelector
implements BoltWireSelector {
    @Override
    public Stream<BoltWire> select(ExtensionContext context) {
        Optional includeAnnotation = AnnotationUtil.findAnnotation((ExtensionContext)context, IncludeWire.class);
        Optional excludeAnnotation = AnnotationUtil.findAnnotation((ExtensionContext)context, ExcludeWire.class);
        ProtocolVersion firstIncluded = includeAnnotation.map(IncludeWire::since).map(this::decodeVersion).filter(it -> !ProtocolVersion.INVALID.equals(it)).orElse(null);
        ProtocolVersion lastIncluded = includeAnnotation.map(IncludeWire::until).map(this::decodeVersion).filter(it -> !ProtocolVersion.INVALID.equals(it)).orElse(null);
        ProtocolVersion firstExcluded = excludeAnnotation.map(ExcludeWire::since).map(this::decodeVersion).filter(it -> !ProtocolVersion.INVALID.equals(it)).orElse(null);
        ProtocolVersion lastExcluded = excludeAnnotation.map(ExcludeWire::until).map(this::decodeVersion).filter(it -> !ProtocolVersion.INVALID.equals(it)).orElse(null);
        List explicitIncludes = includeAnnotation.map(annotation -> Stream.of(annotation.value()).map(this::decodeVersionRange).toList()).orElseGet(Collections::emptyList);
        List explicitExcludes = excludeAnnotation.map(annotation -> Stream.of(annotation.value()).map(this::decodeVersionRange).toList()).orElseGet(Collections::emptyList);
        return BoltWire.versions().filter(wire -> firstIncluded == null || wire.getProtocolVersion().isAtLeast(firstIncluded)).filter(wire -> lastIncluded == null || wire.getProtocolVersion().isAtMost(lastIncluded)).filter(wire -> firstExcluded == null || wire.getProtocolVersion().isOlderThan(firstExcluded)).filter(wire -> lastExcluded == null || wire.getProtocolVersion().isNewerThan(lastExcluded)).filter(wire -> explicitIncludes.isEmpty() || explicitIncludes.stream().anyMatch(range -> range.matches(wire.getProtocolVersion()))).filter(wire -> explicitExcludes.stream().noneMatch(range -> range.matches(wire.getProtocolVersion())));
    }

    private ProtocolVersion decodeVersionRange(Version annotation) {
        if (annotation.minor() == -1) {
            return new ProtocolVersion(annotation.major(), 255, 255);
        }
        return new ProtocolVersion(annotation.major(), annotation.minor(), annotation.range());
    }

    private ProtocolVersion decodeVersion(Version annotation) {
        if (annotation.range() != 0) {
            throw new IllegalArgumentException("Cannot specify range in until/since");
        }
        return new ProtocolVersion(annotation.major(), annotation.minor());
    }
}

