/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tls;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Connected;
import org.neo4j.bolt.test.annotation.connection.transport.preset.PlaintextTransportOnly;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class RequiredTransportSecurityIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.REQUIRED);
    }

    @TransportTest
    @PlaintextTransportOnly
    void shouldCloseUnencryptedConnectionOnHandshakeWhenEncryptionIsRequired(BoltWire wire, @Connected BoltTestConnection connection) throws IOException {
        connection.send(wire.getProtocolVersion());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }
}

