/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TransactionTerminationIT {
    @Inject
    private Neo4jWithSocket server;

    private void awaitTransactionStart() throws InterruptedException {
        Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(2L, TimeUnit.MINUTES).pollInSameThread().untilAsserted(() -> {
            try (Transaction tx = this.server.graphDatabaseService().beginTx();){
                Result result = tx.execute("SHOW TRANSACTIONS");
                int txCount = result.stream().toList().size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)txCount).as("transaction count to exceed 1", new Object[0])).isGreaterThan(1);
            }
        });
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void killTxViaResetV40(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 2000000) AS i CREATE (n)"));
        this.awaitTransactionStart();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesFailureV40(new Status[]{Status.Transaction.Terminated, Status.Transaction.LockClientStopped}).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void killTxViaReset(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 2000000) AS i CREATE (n)"));
        this.awaitTransactionStart();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesFailure(new Pair[]{Pair.of((Object)Status.Transaction.Terminated, (Object)GqlStatusInfoCodes.STATUS_25N14.getGqlStatus()), Pair.of((Object)Status.Transaction.LockClientStopped, (Object)GqlStatusInfoCodes.STATUS_25N14.getGqlStatus())}).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void killTxThenTryToUseItTestV40(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            org.junit.jupiter.api.Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void killTxThenTryToUseItTest(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            org.junit.jupiter.api.Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ", GqlStatusInfoCodes.STATUS_25N14.getGqlStatus(), "error: invalid transaction state - transaction termination client error. The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Reason: Explicitly terminated by the user.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void killedTxShouldNotDestroyConnectionV40(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            org.junit.jupiter.api.Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(100L, TimeUnit.MILLISECONDS).pollDelay(11L, TimeUnit.SECONDS).pollInSameThread().untilAsserted(() -> {
            connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ");
        });
        connection.send(wire.reset()).send(wire.begin()).send(wire.run("RETURN 1 as n")).send(wire.pull(1L)).send(wire.commit());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3).receivesRecord().receivesSuccess(2);
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void killedTxShouldNotDestroyConnection(BoltWire wire, @Authenticated BoltTestConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            org.junit.jupiter.api.Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).pollInterval(100L, TimeUnit.MILLISECONDS).pollDelay(11L, TimeUnit.SECONDS).pollInSameThread().untilAsserted(() -> {
            connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ", GqlStatusInfoCodes.STATUS_25N14.getGqlStatus(), "error: invalid transaction state - transaction termination client error. The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Reason: Explicitly terminated by the user.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"));
        });
        connection.send(wire.reset()).send(wire.begin()).send(wire.run("RETURN 1 as n")).send(wire.pull(1L)).send(wire.commit());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3).receivesRecord().receivesSuccess(2);
    }
}

