/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Connected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class ModernNegotiationIT {
    @Inject
    private OtherThread otherThread;

    @ProtocolTest
    void shouldNegotiateProtocolVersion(BoltWire wire, @Connected BoltTestConnection connection) throws Exception {
        connection.send(new ProtocolVersion(2, 0), new ProtocolVersion(2, 1), ProtocolVersion.NEGOTIATION_V2, new ProtocolVersion(2, 2));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal(proposal -> {
            Assertions.assertThat((Object)proposal).isNotNull();
            Assertions.assertThat((Comparable)proposal.negotiationVersion()).isEqualTo((Object)ProtocolVersion.NEGOTIATION_V2);
            Assertions.assertThat((List)BoltProtocol.available()).allSatisfy(protocol -> Assertions.assertThat((List)proposal.versions()).anyMatch(version -> version.matches(protocol.version())));
            Assertions.assertThat((Collection)proposal.capabilities()).containsAll(EnumSet.noneOf(ProtocolCapability.class));
        });
        connection.send(wire.getProtocolVersion(), EnumSet.noneOf(ProtocolCapability.class));
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"protocol_version", (Object)wire.getProtocolVersion().toString()));
    }

    @ProtocolTest
    void shouldNegotiateProtocolVersionWhenHandshakeRangeIsGiven(BoltWire wire, @Connected BoltTestConnection connection) throws Exception {
        connection.send(new ProtocolVersion(2, 0), new ProtocolVersion(2, 1), new ProtocolVersion((int)ProtocolVersion.NEGOTIATION_V2.major(), 4, 3));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        connection.send(wire.getProtocolVersion(), EnumSet.noneOf(ProtocolCapability.class));
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"protocol_version", (Object)wire.getProtocolVersion().toString()));
    }

    @ProtocolTest
    void shouldUseModernNegotiationBasedOnPriority(BoltWire wire, @Connected BoltTestConnection connection) throws Exception {
        connection.send(ProtocolVersion.NEGOTIATION_V2, wire.getProtocolVersion());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        connection.send(wire.getProtocolVersion(), EnumSet.noneOf(ProtocolCapability.class));
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"protocol_version", (Object)wire.getProtocolVersion().toString()));
    }

    @TransportTest
    void shouldFailIfRangeIsGiven(@Connected BoltTestConnection connection) throws Exception {
        connection.send(ProtocolVersion.NEGOTIATION_V2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        connection.send(new ProtocolVersion(5, 4, 4), EnumSet.noneOf(ProtocolCapability.class));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldFailIfUnknownVersionIsGiven(@Connected BoltTestConnection connection) throws Exception {
        connection.send(ProtocolVersion.NEGOTIATION_V2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        connection.send(new ProtocolVersion(2, 1), EnumSet.noneOf(ProtocolCapability.class));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldFailIfPartialVersionIsGiven(@Connected BoltTestConnection connection) {
        connection.send(ProtocolVersion.NEGOTIATION_V2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        connection.sendRaw(new byte[]{0, 66});
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldTimeoutWhenHandshakeIsTransmittedTooSlowly(@Connected BoltTestConnection connection) {
        connection.send(ProtocolVersion.NEGOTIATION_V2);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesProtocolProposal();
        ByteBuf handshakeBytes = Unpooled.buffer().writeInt(BoltTestConnection.DEFAULT_PROTOCOL_VERSION.encode());
        this.otherThread.execute(() -> {
            while (handshakeBytes.isReadable()) {
                connection.sendRaw(handshakeBytes.readSlice(1));
                Thread.sleep(2000L);
            }
            return null;
        });
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }
}

