/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.List;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ProtocolViolationIT {
    private static void sendRun(BoltTestConnection connection, Consumer<PackstreamBuf> packer) {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("x");
        packer.accept(buf);
        connection.send(buf.writeMapHeader(0L).raw());
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenNullKeyIsSentV40(@Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(1L).writeNull().writeString("foo"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected type: Expected STRING but got NONE");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenNullKeyIsSent(@Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(1L).writeNull().writeString("foo"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected type: Expected STRING but got NONE", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 192 to be of type STRING, but was of type NONE.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 192 to be of type STRING, but was of type NONE.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenDuplicateKeyIsSentV40(@Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(2L).writeString("foo").writeString("bar").writeString("foo").writeString("changed_my_mind"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"params\": Duplicate map key: \"foo\"");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenDuplicateKeyIsSent(@Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(2L).writeString("foo").writeString("bar").writeString("foo").writeString("changed_my_mind"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Duplicate map key: \"foo\"", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"22N54: Multiple conflicting entries specified for 'foo'.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N54.getGqlStatus(), (String)"error: data exception - invalid map. Multiple conflicting entries specified for 'foo'.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenNodeIsSentWithRunV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.nodeValue(buf, "42", 42, List.of("Broken", "Dreams")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x4E");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenNodeIsSentWithRun(BoltWire wire, @Authenticated BoltTestConnection connection) {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.nodeValue(buf, "42", 42, List.of("Broken", "Dreams")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x4E", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N00: The provided value is unsupported and cannot be processed.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), (String)"error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N97: Unexpected struct tag: 0x4E.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N97.getGqlStatus(), (String)"error: data exception - unexpected struct tag. Unexpected struct tag: 0x4E.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenRelationshipIsSentWithRunV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.relationshipValue(buf, "42", 42, "21", 21, "84", 84, "RUINS_EXPECTATIONS"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x52");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenRelationshipIsSentWithRun(BoltWire wire, @Authenticated BoltTestConnection connection) {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.relationshipValue(buf, "42", 42, "21", 21, "84", 84, "RUINS_EXPECTATIONS"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x52", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N00: The provided value is unsupported and cannot be processed.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), (String)"error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N97: Unexpected struct tag: 0x52.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N97.getGqlStatus(), (String)"error: data exception - unexpected struct tag. Unexpected struct tag: 0x52.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenPathIsSentWithRunV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> {
            buf.writeStructHeader(new StructHeader(3L, StructType.PATH.getTag()));
            buf.writeListHeader(2);
            wire.nodeValue(buf, "42", 42, List.of("Computer"));
            wire.nodeValue(buf, "84", 84, List.of("Vendor"));
            buf.writeListHeader(1);
            wire.unboundRelationshipValue(buf, "13", 13, "MAKES");
            buf.writeListHeader(2);
            buf.writeInt(1L);
            buf.writeInt(1L);
        });
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x50");
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenPathIsSentWithRun(BoltWire wire, @Authenticated BoltTestConnection connection) {
        ProtocolViolationIT.sendRun(connection, buf -> {
            buf.writeStructHeader(new StructHeader(3L, StructType.PATH.getTag()));
            buf.writeListHeader(2);
            wire.nodeValue(buf, "42", 42, List.of("Computer"));
            wire.nodeValue(buf, "84", 84, List.of("Vendor"));
            buf.writeListHeader(1);
            wire.unboundRelationshipValue(buf, "13", 13, "MAKES");
            buf.writeListHeader(2);
            buf.writeInt(1L);
            buf.writeInt(1L);
        });
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x50", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N00: The provided value is unsupported and cannot be processed.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), (String)"error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N97: Unexpected struct tag: 0x50.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N97.getGqlStatus(), (String)"error: data exception - unexpected struct tag. Unexpected struct tag: 0x50.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldTerminateConnectionWhenUnknownMessageIsSent(@Authenticated BoltTestConnection connection) {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 66)).writeListHeader(1).writeInt(42L));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenTryToStartTransactionInFailedStateV40(@Authenticated BoltTestConnection connection) {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("foo").writeString("bar");
        connection.send(buf.writeMapHeader(0L).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
        buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 17)).writeMapHeader(0L);
        connection.send(buf.writeMapHeader(0L).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Request.Invalid, "cannot be handled by session in the READY state");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldFailWhenTryToStartTransactionInFailedState(@Authenticated BoltTestConnection connection) {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("foo").writeString("bar");
        connection.send(buf.writeMapHeader(0L).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
        buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 17)).writeMapHeader(0L);
        connection.send(buf.writeMapHeader(0L).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "cannot be handled by session in the READY state", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", GqlStatusInfoCodes.STATUS_08N10.getGqlStatus(), "error: connection exception - invalid server state. Message BeginMessage{bookmarks=[], txTimeout=null, accessMode=WRITE, txMetadata=null, databaseName='null', impersonatedUser='null', notificationsConfig=Default, type=EXPLICIT} cannot be handled by session in the 'READY' state.");
    }
}

