/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExcludeWire(until=@Version(major=4, minor=2))
public class RoutingTableIT {
    @Inject
    private Neo4jWithSocket server;

    private static void assertRoutingTableHasCorrectShape(Map<?, ?> routingTable) {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            Assertions.assertThat((boolean)routingTable.containsKey("ttl")).isTrue();
            Assertions.assertThat(routingTable.get("ttl")).isInstanceOf(Long.class);
        }, () -> {
            Assertions.assertThat((boolean)routingTable.containsKey("servers")).isTrue();
            ((ObjectAssert)Assertions.assertThat(routingTable.get("servers")).isInstanceOf(List.class)).satisfies(new ThrowingConsumer[]{s -> {
                List servers = (List)s;
                for (Object srv : servers) {
                    Assertions.assertThat(srv).isInstanceOf(Map.class);
                    Map server = (Map)srv;
                    org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
                        Assertions.assertThat((boolean)server.containsKey("role")).isTrue();
                        Assertions.assertThat(server.get("role")).isIn(new Object[]{"READ", "WRITE", "ROUTE"});
                    }, () -> {
                        Assertions.assertThat((boolean)server.containsKey("addresses")).isTrue();
                        ((ObjectAssert)Assertions.assertThat(server.get("addresses")).isInstanceOf(List.class)).satisfies(new ThrowingConsumer[]{ad -> {
                            List addresses = (List)ad;
                            for (Object address : addresses) {
                                Assertions.assertThat(address).isInstanceOf(String.class);
                            }
                        }});
                    }});
                }
            }});
        }});
    }

    @ProtocolTest
    void shouldRespondToRouteMessage(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.route());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(metadata -> Assertions.assertThat((Map)metadata).hasEntrySatisfying((Object)"rt", rt -> ((MapAssert)Assertions.assertThat((Object)rt).asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).satisfies(new ThrowingConsumer[]{RoutingTableIT::assertRoutingTableHasCorrectShape})));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=1))
    void shouldReturnTheSameRoutingForTwoDifferentUsers(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.route(null, null, "neo4j"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(metadata -> {
            Assertions.assertThat((boolean)metadata.containsKey("rt")).isTrue();
            ((ObjectAssert)Assertions.assertThat(metadata.get("rt")).isInstanceOf(Map.class)).satisfies(new ThrowingConsumer[]{rt -> RoutingTableIT.assertRoutingTableHasCorrectShape((Map)rt)});
        });
        connection.send(wire.run("CREATE USER neo4j2 SET PASSWORD 'neo4jneo4jneo4j' CHANGE NOT REQUIRED"));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        connection.send(wire.logoff());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j2", "credentials", "neo4jneo4jneo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.route(null, null, "neo4j"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(metadata -> {
            Assertions.assertThat((boolean)metadata.containsKey("rt")).isTrue();
            ((ObjectAssert)Assertions.assertThat(metadata.get("rt")).isInstanceOf(Map.class)).satisfies(new ThrowingConsumer[]{rt -> RoutingTableIT.assertRoutingTableHasCorrectShape((Map)rt)});
        });
    }

    @ProtocolTest
    void shouldRespondToRouteMessageWithBookmark(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.route(null, List.of("test-bookmark"), null));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(metadata -> {
            Assertions.assertThat((boolean)metadata.containsKey("rt")).isTrue();
            ((ObjectAssert)Assertions.assertThat(metadata.get("rt")).isInstanceOf(Map.class)).satisfies(new ThrowingConsumer[]{rt -> RoutingTableIT.assertRoutingTableHasCorrectShape((Map)rt)});
        });
    }

    @ProtocolTest
    void shouldReturnFailureIfRoutingTableFailedToReturn(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.route(null, null, "DOESNT_EXIST!"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.route());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(metadata -> {
            Assertions.assertThat((boolean)metadata.containsKey("rt")).isTrue();
            ((ObjectAssert)Assertions.assertThat(metadata.get("rt")).isInstanceOf(Map.class)).satisfies(new ThrowingConsumer[]{rt -> RoutingTableIT.assertRoutingTableHasCorrectShape((Map)rt)});
        });
    }

    @ProtocolTest
    void shouldIgnoreRouteMessageWhenInFailedState(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("\u2728\u2728\u2728 Magical Crash String \u2728\u2728\u2728"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure();
        connection.send(wire.route());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesIgnored();
    }
}

