/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.struct.AbstractStructArgumentIT;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.TypeMarker;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class VectorErrorIT
extends AbstractStructArgumentIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(GraphDatabaseInternalSettings.cypher_enable_extra_semantic_features, Set.of("VectorType"));
        settings.put(GraphDatabaseSettings.default_language, GraphDatabaseSettings.CypherVersion.Cypher25);
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenVectorSentOnIncompatibleProtocol(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnknownStructV40(connection, buf -> buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag())).writeString("boom"), "Illegal value for field \"params\": Unexpected struct tag: 0x56");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailWhenVectorSentOnIncompatibleProtocolGql(@Authenticated BoltTestConnection connection) {
        this.testFailureWithUnknownStruct(connection, buf -> buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag())).writeString("boom"), "Illegal value for field \"params\": Unexpected struct tag: 0x56", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N00: The provided value is unsupported and cannot be processed.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), (String)"error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N97: Unexpected struct tag: 0x56.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N97.getGqlStatus(), (String)"error: data exception - unexpected struct tag. Unexpected struct tag: 0x56.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailWhenVectorReceivedOnIncompatibleProtocolGql(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("RETURN VECTOR([1, 2, 3], 3, INTEGER64)"));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesFailureWithCause((Status)Status.Request.Invalid, "Struct tag: 0x56 representing type VECTOR is not supported for this protocol version", GqlStatusInfoCodes.STATUS_22N00.getGqlStatus(), "error: data exception - unsupported value. The provided value is unsupported and cannot be processed.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"22NBD: Unsupported struct tag: 0x56.", (GqlStatus)GqlStatusInfoCodes.STATUS_22NBD.getGqlStatus(), (String)"error: data exception - unsupported struct tag. Unsupported struct tag: 0x56.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldBeSuccessfulForValidStruct(@Authenticated BoltTestConnection connection) {
        connection.send(this.createRunWith(buf -> {
            buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag()));
            buf.writeBytes(Unpooled.buffer().writeByte((int)TypeMarker.INT8.getValue()));
            buf.writeBytes(Unpooled.buffer().writeBytes(new byte[]{1, 2, 3}));
        }));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldErrorForInvalidVectorType(@Authenticated BoltTestConnection connection) {
        connection.send(this.createRunWith(buf -> {
            buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag()));
            buf.writeBytes(Unpooled.buffer().writeByte((int)TypeMarker.MAP8.getValue()));
            buf.writeBytes(Unpooled.buffer().writeBytes(new byte[]{1, 2, 3}));
        }));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Illegal value for field \"type\": Given type is not a valid vector value type", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 216 to be of type INT8, INT16, INT32, INT64, FLOAT32 or FLOAT64, but was of type MAP8.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 216 to be of type INT8, INT16, INT32, INT64, FLOAT32 or FLOAT64, but was of type MAP8.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldErrorForInvalidTypeMarkerType(@Authenticated BoltTestConnection connection) {
        connection.send(this.createRunWith(buf -> {
            buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag()));
            buf.writeInt64(Long.MAX_VALUE);
        }));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected type: Expected BYTES but got INT", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 203 to be of type BYTES, but was of type INT.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 203 to be of type BYTES, but was of type INT.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldErrorForInvalidVectorContents(@Authenticated BoltTestConnection connection) {
        connection.send(this.createRunWith(buf -> {
            buf.writeStructHeader(new StructHeader(2L, StructType.VECTOR.getTag()));
            buf.writeBytes(Unpooled.buffer().writeByte((int)TypeMarker.INT8.getValue()));
            buf.writeInt64(Long.MAX_VALUE);
        }));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected type: Expected BYTES but got INT", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 203 to be of type BYTES, but was of type INT.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 203 to be of type BYTES, but was of type INT.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }
}

