/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.protocol.common.connector.connection.ConnectionHandle;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Authenticated;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
class ReadyStateIT {
    ReadyStateIT() {
    }

    @StateMachineTest
    void shouldMoveToInterruptedOnInterrupt(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.connection().interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInterrupted();
    }

    private void shouldCloseConnectionOnMessage(StateMachine fsm, RequestMessage message) {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(message, (ResponseHandler)recorder));
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    @StateMachineTest
    void shouldCloseConnectionOnPull(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.pull());
    }

    @StateMachineTest
    void shouldCloseConnectionOnDiscard(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.discard());
    }

    @StateMachineTest
    void shouldCloseConnectionOnCommit(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.commit());
    }

    @StateMachineTest
    void shouldCloseConnectionOnRollback(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.rollback());
    }

    @StateMachineTest
    void shouldCloseConnectionOnGoodbye(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.goodbye());
    }

    @StateMachineTest(until=@Version(major=5, minor=6))
    void shouldMoveToAutoCommitOnRunNoDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.run("CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first").doesNotContainKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTO_COMMIT);
    }

    static void mockTransaction(StateMachine fsm, String homeDb) throws Throwable {
        Transaction txMock = (Transaction)Mockito.mock(Transaction.class);
        Statement statementMock = (Statement)Mockito.mock(Statement.class);
        ((ConnectionHandle)Mockito.doReturn((Object)homeDb).when((Object)fsm.connection())).selectedDefaultDatabase();
        ((ConnectionHandle)Mockito.doReturn((Object)txMock).when((Object)fsm.connection())).beginTransaction((TransactionType)Mockito.any(), (String)Mockito.any(), (AccessMode)Mockito.any(), (List)Mockito.any(), (Duration)Mockito.any(), (Map)Mockito.any(), (NotificationsConfig)Mockito.any());
        ((Transaction)Mockito.doReturn((Object)statementMock).when((Object)txMock)).run((String)Mockito.any(), (MapValue)Mockito.any());
        ((Statement)Mockito.doReturn((Object)1L).when((Object)statementMock)).id();
        ((Statement)Mockito.doReturn(List.of("coolField")).when((Object)statementMock)).fieldNames();
    }

    @StateMachineTest(since=@Version(major=5, minor=8))
    void shouldMoveToAutoCommitOnRunWithDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        String expectedHomeDb = "neo5j";
        ReadyStateIT.mockTransaction(fsm, "neo5j");
        fsm.process(messages.run("CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first").containsEntry("db", (AnyValue)Values.of((Object)"neo5j")));
        ((ConnectionHandle)Mockito.verify((Object)fsm.connection())).resolveDefaultDatabase();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTO_COMMIT);
    }

    @StateMachineTest
    void shouldMoveToAutoCommitOnRunOnSelectedDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        ReadyStateIT.mockTransaction(fsm, "someOtherDb");
        fsm.process(messages.run("CREATE (n {k:'k'}) RETURN n.k", "neo5j"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first").doesNotContainKey("db"));
        ((ConnectionHandle)Mockito.verify((Object)fsm.connection(), (VerificationMode)Mockito.never())).resolveDefaultDatabase();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTO_COMMIT);
    }

    @StateMachineTest(until=@Version(major=5, minor=6))
    void shouldMoveToInTransactionOnBeginNoDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("db"));
        ((ConnectionHandle)Mockito.verify((Object)fsm.connection(), (VerificationMode)Mockito.never())).resolveDefaultDatabase();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest(since=@Version(major=5, minor=8))
    void shouldMoveToInTransactionWithBeginWithDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("db", (AnyValue)Values.of((Object)fsm.connection().selectedDefaultDatabase())));
        ((ConnectionHandle)Mockito.verify((Object)fsm.connection())).resolveDefaultDatabase();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldMoveToInTransactionWithBeginOnSelectedDb_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        ReadyStateIT.mockTransaction(fsm, "someOtherDb");
        fsm.process(messages.begin("neo4j"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("db"));
        ((ConnectionHandle)Mockito.verify((Object)fsm.connection(), (VerificationMode)Mockito.never())).resolveDefaultDatabase();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest(since=@Version(major=5, minor=1))
    void shouldMoveBackToAuthenticationStateAfterALogoffMessage(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        fsm.process(messages.logon(), (ResponseHandler)recorder);
        fsm.process(messages.logoff(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTHENTICATION);
    }
}

