/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.resolver;

import io.netty.channel.local.LocalAddress;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.neo4j.bolt.test.connection.resolver.AbstractAddressResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.transport.Neo4jWithSocket;

public final class DefaultAddressResolver
extends AbstractAddressResolver {
    @Override
    public SocketAddress doResolve(ExtensionContext extensionContext, ParameterContext context, Neo4jWithSocket server, TransportType transportType) {
        if (transportType.equals((Object)TransportType.UNIX)) {
            return new DomainSocketAddress(server.lookupUnixConnector().toFile());
        }
        if (transportType.equals((Object)TransportType.LOCAL)) {
            return new LocalAddress(server.lookupLocalConnector());
        }
        return server.lookupDefaultConnector().toSocketAddress();
    }
}

