/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.connection.transport.DefaultTransportSelector;
import org.neo4j.bolt.test.connection.transport.TransportSelector;
import org.neo4j.bolt.test.extension.BoltTestConfig;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.test.extension.error.TestRetryException;
import org.neo4j.bolt.test.extension.store.RetryInfo;
import org.neo4j.bolt.test.wire.initializer.BoltWireInitializer;
import org.neo4j.bolt.test.wire.selector.BoltWireSelector;
import org.neo4j.bolt.test.wire.selector.DefaultBoltWireSelector;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public final class BoltTestSupportExtension
implements TestTemplateInvocationContextProvider,
TestWatcher {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{BoltTestSupportExtension.class});
    private static final String ITERATOR_KEY = "test_iterator";

    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Optional<Class> supportAnnotation = context.getTestMethod().flatMap(method -> AnnotationSupport.findAnnotation((AnnotatedElement)method, BoltTestExtension.class)).or(() -> context.getTestClass().flatMap(type -> AnnotationSupport.findAnnotation((AnnotatedElement)type, BoltTestExtension.class)));
        Class databaseFactoryType = supportAnnotation.map(BoltTestExtension::databaseManagementServiceBuilder).filter(type -> BoltTestExtension.PlaceholderTestDatabaseManagementServiceBuilder.class != type).orElseGet(() -> this.getDefaultDatabaseFactoryType());
        ServerInstanceContext instanceContext = ServerInstanceContext.forExtensionContext(context, databaseFactoryType, Collections.emptyList(), List.of((ctx, settings) -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        }));
        ConnectorTransport transport = (ConnectorTransport)ConnectorTransport.selectOptimal().orElseThrow(() -> new TestInstantiationException("No transports available within execution environment"));
        Iterator<BoltTestConfig> templates = this.getTransportTypes(context).filter(transportType -> transportType.getFactory().isSupported(transport)).flatMap(transportType -> this.getWires(context).map(wire -> this.configure(databaseFactoryType, instanceContext, transport, (TransportType)transportType, (BoltWire)wire))).iterator();
        TestTemplateIterator it = new TestTemplateIterator(templates);
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)ITERATOR_KEY, (Object)it);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 256), false);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        if (cause instanceof TestRetryException) {
            TestRetryException ex = (TestRetryException)((Object)cause);
            ExtensionContext.Store store = context.getStore(NAMESPACE);
            TestTemplateIterator it = (TestTemplateIterator)store.get((Object)ITERATOR_KEY, TestTemplateIterator.class);
            if (it == null) {
                return;
            }
            RetryInfo info = ex.getRetryInfo();
            it.markForRetry(info);
        }
    }

    protected BoltTestConfig configure(Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, ServerInstanceContext instanceContext, ConnectorTransport transport, TransportType transportType, BoltWire wire) {
        return new BoltTestConfig(databaseFactoryType, instanceContext, transport, transportType, wire);
    }

    protected Class<? extends TestDatabaseManagementServiceBuilder> getDefaultDatabaseFactoryType() {
        return TestDatabaseManagementServiceBuilder.class;
    }

    protected Stream<BoltWire> getWires(ExtensionContext context) {
        BoltWireSelector selector = BoltWireSelector.findSelector(context).orElseGet(DefaultBoltWireSelector::new);
        List<BoltWireInitializer> initializers = BoltWireInitializer.findInitializer(context);
        return selector.select(context).peek(wire -> initializers.forEach(initializer -> initializer.initialize(context, (BoltWire)wire)));
    }

    protected Stream<TransportType> getTransportTypes(ExtensionContext context) {
        TransportSelector selector = TransportSelector.findSelector(context).orElseGet(DefaultTransportSelector::new);
        return selector.select(context);
    }

    private static final class TestTemplateIterator
    implements Iterator<TestTemplateInvocationContext> {
        private final Iterator<BoltTestConfig> delegate;
        private BoltTestConfig previous;
        private RetryInfo retry;

        public TestTemplateIterator(Iterator<BoltTestConfig> delegate) {
            this.delegate = delegate;
        }

        public void markForRetry(RetryInfo info) {
            this.retry = info;
        }

        @Override
        public boolean hasNext() {
            if (this.retry != null && this.previous != null) {
                return true;
            }
            return this.delegate.hasNext();
        }

        @Override
        public TestTemplateInvocationContext next() {
            BoltTestConfig next;
            RetryInfo retry = this.retry;
            this.retry = null;
            if (retry != null && this.previous != null) {
                return new RenamingTestTemplateInvocationContext(this.previous, retry);
            }
            this.previous = next = this.delegate.next();
            return next;
        }
    }

    private static final class RenamingTestTemplateInvocationContext
    implements TestTemplateInvocationContext {
        private final TestTemplateInvocationContext delegate;
        private final RetryInfo retry;

        public RenamingTestTemplateInvocationContext(TestTemplateInvocationContext delegate, RetryInfo info) {
            this.delegate = delegate;
            this.retry = info;
        }

        public String getDisplayName(int invocationIndex) {
            return this.delegate.getDisplayName(invocationIndex) + " (Retry " + String.valueOf(this.retry) + ")";
        }

        public List<Extension> getAdditionalExtensions() {
            return this.delegate.getAdditionalExtensions();
        }
    }
}

