/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.util;

import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntegralValue;

public final class ServerUtil {
    private ServerUtil() {
    }

    public static NamedDatabaseId getDatabaseId(Neo4jWithSocket server) {
        DependencyResolver resolver = ((GraphDatabaseAPI)server.graphDatabaseService()).getDependencyResolver();
        Database database = (Database)resolver.resolveDependency(Database.class);
        return database.getNamedDatabaseId();
    }

    public static long getLastClosedTransactionId(Neo4jWithSocket server) {
        DependencyResolver resolver = ((GraphDatabaseAPI)server.graphDatabaseService()).getDependencyResolver();
        TransactionIdStore txIdStore = (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }

    public static <T> T resolveDependency(Neo4jWithSocket server, Class<T> type) {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)server.graphDatabaseService();
        return (T)dbApi.getDependencyResolver().resolveDependency(type);
    }

    private static GlobalProcedures getProcedures(Neo4jWithSocket server) {
        return ServerUtil.resolveDependency(server, GlobalProcedures.class);
    }

    public static <T> void registerComponent(Neo4jWithSocket server, Class<T> type, ThrowingFunction<Context, T, ProcedureException> provider) {
        ServerUtil.getProcedures(server).registerComponent(type, provider, true);
    }

    public static void installProcedure(Neo4jWithSocket server, CallableProcedure procedure) throws ProcedureException {
        ServerUtil.getProcedures(server).register(procedure);
    }

    public static void installProcedure(Neo4jWithSocket server, Class<?> procedure) throws KernelException {
        ServerUtil.getProcedures(server).registerProcedure(procedure);
    }

    public static void installSleepProcedure(Neo4jWithSocket server) throws ProcedureException {
        ServerUtil.installProcedure(server, (CallableProcedure)new CallableProcedure.BasicProcedure(ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName("boltissue", "sleep")).in("data", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ProcedureSignature.VOID).build()){

            public ResourceRawIterator<AnyValue[], ProcedureException> apply(Context context, AnyValue[] objects, ResourceMonitor resourceMonitor) throws ProcedureException {
                try {
                    Thread.sleep(((IntegralValue)objects[0]).longValue());
                }
                catch (InterruptedException e) {
                    throw ProcedureException.internalError((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Interrupted", (Status)Status.General.UnknownError, (Throwable)e);
                }
                return ResourceRawIterator.empty();
            }
        });
    }
}

