/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.util.ErrorUtil;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.testing.PackstreamBufAssertions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class BasicOperationIT {
    public static final String ELEMENT_ID_PATTERN = "\\d+:[\\da-f]{8}\\-[\\da-f]{4}\\-[\\da-f]{4}\\-[\\da-f]{4}\\-[\\da-f]{12}:\\d+";

    @ProtocolTest
    void shouldRunSimpleStatement(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(2)).containsExactly((Object[])new String[]{"a", "a_squared"}))).receivesRecord(new AnyValue[]{Values.longValue((long)1L), Values.longValue((long)1L)}).receivesRecord(new AnyValue[]{Values.longValue((long)2L), Values.longValue((long)4L)}).receivesRecord(new AnyValue[]{Values.longValue((long)3L), Values.longValue((long)9L)}).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    void shouldRespondWithMetadataToDiscardAll(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")).send(wire.discard());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(2)).containsExactly((Object[])new String[]{"a", "a_squared"}))).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldBeAbleToRunQueryAfterAckFailureV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("QINVALID")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Statement.SyntaxError, "line 1, column 1").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldBeAbleToRunQueryAfterAckFailureV5x7(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("QINVALID")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyWithCause((Status)Status.Statement.SyntaxError, "line 1, column 1", GqlStatusInfoCodes.STATUS_42001.getGqlStatus(), "error: syntax error or access rule violation - invalid syntax", BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)1L, (long)1L, (long)0L)), BoltConnectionAssertions.assertErrorCause((String)"42I06: Invalid input 'QINVALID', expected:", (GqlStatus)GqlStatusInfoCodes.STATUS_42I06.getGqlStatus(), (String)"error: syntax error or access rule violation - invalid input. Invalid input 'QINVALID', expected:", (Consumer)BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)1L, (long)1L, (long)0L)))).receivesIgnored();
        connection.send(wire.reset()).send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldBeAbleToRunQueryAfterAckFailure(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("QINVALID")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyWithCause((Status)Status.Statement.SyntaxError, ErrorUtil.useNewMessage((String)"42001").whenLegacyFallbackTo("line 1, column 1"), GqlStatusInfoCodes.STATUS_42001.getGqlStatus(), "error: syntax error or access rule violation - invalid syntax", BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)1L, (long)1L, (long)0L)), BoltConnectionAssertions.assertErrorCause((String)"42I06: Invalid input 'QINVALID', expected:", (GqlStatus)GqlStatusInfoCodes.STATUS_42I06.getGqlStatus(), (String)"error: syntax error or access rule violation - invalid input. Invalid input 'QINVALID', expected:", (Consumer)BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)1L, (long)1L, (long)0L)))).receivesIgnored();
        connection.send(wire.reset()).send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess();
    }

    @ProtocolTest
    void shouldRunProcedure(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (n:Test {age: 2}) RETURN n.age AS age")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"age"}))).receivesRecord(new AnyValue[]{Values.longValue((long)2L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
        connection.send(wire.run("CALL db.labels() YIELD label")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"label"}))).receivesRecord(new AnyValue[]{Values.stringValue((String)"Test")}).receivesSuccess();
    }

    @ProtocolTest
    void shouldHandleDeletedNodes(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (n:Test) DELETE n RETURN n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"n"}))).packstreamSatisfies(pack -> ((PackstreamBufAssertions)pack.receivesMessage().containsStruct(113, 1L).containsLengthPrefixMarker(Type.LIST, 1L).containsStruct(78, wire.getProtocolVersion().major() >= 5 ? 4L : 3L).containsInt(0L).containsList(labels -> Assertions.assertThat((List)labels).isEmpty()).containsMap(props -> Assertions.assertThat((Map)props).isEmpty()).satisfies(new ThrowingConsumer[]{buf -> {
            if (wire.getProtocolVersion().major() < 5) {
                return;
            }
            PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsString(elementId -> Assertions.assertThat((String)elementId).matches((CharSequence)ELEMENT_ID_PATTERN));
        }})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
    }

    @ProtocolTest
    void shouldHandleDeletedRelationships(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (a)-[r:T {prop: 42}]->(b) DELETE r RETURN r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"r"}))).packstreamSatisfies(pack -> ((PackstreamBufAssertions)pack.receivesMessage().containsStruct(113, 1L).containsLengthPrefixMarker(Type.LIST, 1L).containsStruct(82, wire.getProtocolVersion().major() >= 5 ? 8L : 5L).containsAInt().containsInt(-1L).containsInt(-1L).containsString("").containsMap(props -> Assertions.assertThat((Map)props).isEmpty()).satisfies(new ThrowingConsumer[]{buf -> {
            if (wire.getProtocolVersion().major() < 5) {
                return;
            }
            PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsString(elementId -> Assertions.assertThat((String)elementId).matches((CharSequence)ELEMENT_ID_PATTERN)).containsString("").containsString("");
        }})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldNotLeakStatsToNextStatement(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("CREATE (n)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=5))
    void shouldSendNotifications(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, 17, 1, 18);
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=5))
    void shouldSendGqlStatus(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist in database `neo4j`. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL", "db", "neo4j"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailNicelyWhenDroppingUnknownIndexV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("DROP INDEX my_index")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Schema.IndexDropFailed, "Unable to drop index called `my_index`. There is no such index.").receivesIgnored();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailNicelyWhenDroppingUnknownIndexV5x7(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("DROP INDEX my_index")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Schema.IndexDropFailed, "Unable to drop index called `my_index`. There is no such index.", GqlStatusInfoCodes.STATUS_50N10.getGqlStatus(), "error: general processing exception - index drop failed. Unable to drop 'my_index'.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"DATABASE_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"22N69: The index 'my_index' does not exist.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N69.getGqlStatus(), (String)"error: data exception - index does not exist. The index 'my_index' does not exist.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))).receivesIgnored();
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldFailNicelyWhenDroppingUnknownIndex(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("DROP INDEX my_index")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Schema.IndexDropFailed, ErrorUtil.useNewMessage((String)"50N10: Unable to drop 'my_index'.").whenLegacyFallbackTo("Unable to drop index called `my_index`. There is no such index."), GqlStatusInfoCodes.STATUS_50N10.getGqlStatus(), "error: general processing exception - index drop failed. Unable to drop 'my_index'.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"DATABASE_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"22N69: The index 'my_index' does not exist.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N69.getGqlStatus(), (String)"error: data exception - index does not exist. The index 'my_index' does not exist.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))).receivesIgnored();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailNicelyWhenSubmittingInvalidStatementV40(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("MATCH (:Movie{title:'"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Statement.SyntaxError, "Failed to parse string literal");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailNicelyWhenSubmittingInvalidStatement5x7(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("MATCH (:Movie{title:'"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyWithCause((Status)Status.Statement.SyntaxError, "Failed to parse string literal", GqlStatusInfoCodes.STATUS_42001.getGqlStatus(), "error: syntax error or access rule violation - invalid syntax", BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)21L, (long)1L, (long)20L)), BoltConnectionAssertions.assertErrorCause((String)"42I19: Failed to parse string literal. The query must contain an even number of non-escaped quotes.", (GqlStatus)GqlStatusInfoCodes.STATUS_42I19.getGqlStatus(), (String)"error: syntax error or access rule violation - invalid string literal. Failed to parse string literal. The query must contain an even number of non-escaped quotes.", (Consumer)BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)21L, (long)1L, (long)20L))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldFailNicelyWhenSubmittingInvalidStatement(BoltWire wire, @Authenticated BoltTestConnection connection) {
        connection.send(wire.run("MATCH (:Movie{title:'"));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyWithCause((Status)Status.Statement.SyntaxError, ErrorUtil.useNewMessage((String)"42001").whenLegacyFallbackTo("Failed to parse string literal"), GqlStatusInfoCodes.STATUS_42001.getGqlStatus(), "error: syntax error or access rule violation - invalid syntax", BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)21L, (long)1L, (long)20L)), BoltConnectionAssertions.assertErrorCause((String)"42I19: Failed to parse string literal. The query must contain an even number of non-escaped quotes.", (GqlStatus)GqlStatusInfoCodes.STATUS_42I19.getGqlStatus(), (String)"error: syntax error or access rule violation - invalid string literal. Failed to parse string literal. The query must contain an even number of non-escaped quotes.", (Consumer)BoltConnectionAssertions.assertErrorClassificationAndPositionOnDiagnosticRecord((String)"CLIENT_ERROR", (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)21L, (long)1L, (long)20L))));
    }
}

