/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Connected;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.util.ErrorUtil;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class MalformedMessageIT {
    @TransportTest
    void shouldHandleIncorrectFraming(BoltWire wire, @Connected BoltTestConnection connection) {
        ByteBuf msg = wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared");
        ByteBuf truncated = msg.readSlice(msg.readableBytes() - 12);
        connection.connect().sendDefaultProtocolVersion().send(truncated);
        ((BoltConnectionAssertions)BoltConnectionAssertions.assertThat((BoltTestConnection)connection).negotiatesDefaultVersion()).isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldHandleMessagesWithIncorrectFieldsV40(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN 1").writeMapHeader(0L).writeInt(42L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"metadata\": Unexpected type: Expected MAP but got INT");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldHandleMessagesWithIncorrectFieldsV5x7(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN 1").writeMapHeader(0L).writeInt(42L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"metadata\": Unexpected type: Expected MAP but got INT", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 0 to be of type MAP, but was of type INT.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 0 to be of type MAP, but was of type INT.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldHandleMessagesWithIncorrectFields(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN 1").writeMapHeader(0L).writeInt(42L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, ErrorUtil.useNewMessage("08N06: General network protocol error.").whenLegacyFallbackTo("Illegal value for field \"metadata\": Unexpected type: Expected MAP but got INT"), GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 0 to be of type MAP, but was of type INT.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 0 to be of type MAP, but was of type INT.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldHandleUnknownMarkerBytesV40(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeMarkerByte(199).writeMapHeader(0L).writeMapHeader(0L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"statement\": Unexpected type: Expected STRING but got RESERVED");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldHandleUnknownMarkerBytesV5x7(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeMarkerByte(199).writeMapHeader(0L).writeMapHeader(0L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"statement\": Unexpected type: Expected STRING but got RESERVED", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 0 to be of type STRING, but was of type RESERVED.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 0 to be of type STRING, but was of type RESERVED.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldHandleUnknownMarkerBytes(@VersionSelected BoltTestConnection connection) {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeMarkerByte(199).writeMapHeader(0L).writeMapHeader(0L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, ErrorUtil.useNewMessage("08N06: General network protocol error.").whenLegacyFallbackTo("Illegal value for field \"statement\": Unexpected type: Expected STRING but got RESERVED"), GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 0 to be of type STRING, but was of type RESERVED.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 0 to be of type STRING, but was of type RESERVED.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @TransportTest
    void shouldCloseConnectionOnInvalidHandshake(@Connected BoltTestConnection connection) {
        connection.sendRaw(new byte[]{-34, -83, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }
}

