/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.Index;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.assertions.AnyValueAssertions;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.assertions.ListValueAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class NetworkingProceduresIT {
    @ProtocolTest
    void shouldKillConnection(BoltWire wire, @Authenticated BoltTestConnection connection, @Authenticated ConnectionProvider provider) {
        AnyValue connectionId = NetworkingProceduresIT.getConnectionIdFromSingleConnection(wire, connection);
        try (BoltTestConnection otherConnection = provider.create();){
            otherConnection.send(wire.run("CALL dbms.killConnection($id)", VirtualValues.map((String[])new String[]{"id"}, (AnyValue[])new AnyValue[]{connectionId}))).send(wire.pull());
            BoltConnectionAssertions.assertThat((BoltTestConnection)otherConnection).receivesSuccess().receivesRecord(fields -> ((ListValueAssertions)((ListValueAssertions)((ListValueAssertions)ListValueAssertions.assertThat((ListValue)fields).hasSize(3)).satisfies(element -> AnyValueAssertions.assertThat((AnyValue)element).isNotNull(), Index.atIndex((int)0))).contains((Object)connectionId, Index.atIndex((int)0))).contains((Object)Values.stringValue((String)"Connection found"), Index.atIndex((int)2))).receivesSuccess();
        }
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldKillConnectionHandleUnexistingConnections(BoltWire wire, @Authenticated BoltTestConnection connection) {
        TextValue connectionId = Values.stringValue((String)"unknown");
        connection.send(wire.run("CALL dbms.killConnection($id)", VirtualValues.map((String[])new String[]{"id"}, (AnyValue[])new AnyValue[]{connectionId}))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesRecord(fields -> ((ListValueAssertions)((ListValueAssertions)((ListValueAssertions)ListValueAssertions.assertThat((ListValue)fields).hasSize(3)).satisfies(element -> AnyValueAssertions.assertThat((AnyValue)element).isNotNull(), Index.atIndex((int)0))).contains((Object)connectionId, Index.atIndex((int)0))).contains((Object)Values.stringValue((String)"No connection found with this id"), Index.atIndex((int)2))).receivesSuccess();
    }

    private static AnyValue getConnectionIdFromSingleConnection(BoltWire wire, BoltTestConnection connection) {
        AtomicReference connectionId = new AtomicReference();
        connection.send(wire.run("CALL dbms.listConnections()")).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess().receivesRecord(fields -> ((ListValueAssertions)ListValueAssertions.assertThat((ListValue)fields).hasSize(7)).satisfies(new ThrowingConsumer[]{element -> connectionId.set((AnyValue)element.getFirst())})).receivesSuccess();
        return (AnyValue)connectionId.get();
    }
}

