/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.connection.transport.IncludeTransport;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@IncludeTransport(value={TransportType.UNIX})
@DisabledOnOs(value={OS.WINDOWS})
public class UnixDomainSocketIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.enable_unix_socket_user_database_access, false);
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldForceDisableRouting(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello(msg -> ((HelloMessageBuilder)msg.withoutAuth()).withRoutingContext(new RoutingContext(true, Map.of()))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "Routing is not supported on this connector", GqlStatusInfoCodes.STATUS_51N78.getGqlStatus(), "Routing is not permitted via this connector. Switch the connection URI scheme to bolt:// or connect to a connector with routing support.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=4, minor=1), until=@Version(major=5, minor=6))
    void shouldForceDisableRoutingV50(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello(msg -> ((HelloMessageBuilder)msg.withoutAuth()).withRoutingContext(new RoutingContext(true, Map.of()))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Request.Invalid, "Routing is not supported on this connector");
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldPreventUserDatabaseAccessViaImplicitTransactionV40(BoltWire wire, @Authenticated BoltTestConnection connection) throws IOException {
        connection.send(wire.run("RETURN 1", msg -> msg.withDatabase("neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Request.Invalid, "Only system database access is permitted via UNIX domain sockets");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7))
    void shouldPreventUserDatabaseAccessViaImplicitTransaction(BoltWire wire, @Authenticated BoltTestConnection connection) throws IOException {
        connection.send(wire.run("RETURN 1", msg -> msg.withDatabase("neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "Cannot access database \"neo4j\": Only system database access is permitted via UNIX domain sockets", GqlStatusInfoCodes.STATUS_51N79.getGqlStatus(), "Access to database `$db` is not permitted via this connector.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldPreventUserDatabaseAccessViaExplicitTransaction(BoltWire wire, @Authenticated BoltTestConnection connection) throws IOException {
        connection.send(wire.begin(msg -> msg.withDatabase("neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Request.Invalid, "Only system database access is permitted via UNIX domain sockets");
    }
}

