/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.testing.util.ErrorUtil;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class UserAgentIT {
    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenUserAgentIsOmittedV40(@VersionSelected BoltTestConnection connection) {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none")).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected value to be non-null");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailWhenUserAgentIsOmittedV5x7(@VersionSelected BoltTestConnection connection) {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none")).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected value to be non-null", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N05: Invalid input 'null' for field 'user_agent'.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N05.getGqlStatus(), (String)"error: data exception - input failed validation. Invalid input 'null' for field 'user_agent'.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22004", (GqlStatus)GqlStatusInfoCodes.STATUS_22004.getGqlStatus(), (String)"error: data exception - null value not allowed", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldFailWhenUserAgentIsOmitted(@VersionSelected BoltTestConnection connection) {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none")).raw());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, ErrorUtil.useNewMessage((String)"08N06: General network protocol error.").whenLegacyFallbackTo("Illegal value for field \"user_agent\": Expected value to be non-null"), GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N05: Invalid input 'null' for field 'user_agent'.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N05.getGqlStatus(), (String)"error: data exception - input failed validation. Invalid input 'null' for field 'user_agent'.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22004", (GqlStatus)GqlStatusInfoCodes.STATUS_22004.getGqlStatus(), (String)"error: data exception - null value not allowed", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(until=@Version(major=5, minor=6))
    void shouldFailWhenInvalidUserAgentIsGivenV40(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withUserAgent((Object)42L)));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected string");
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=5, minor=7), until=@Version(major=5, minor=8))
    void shouldFailWhenInvalidUserAgentIsGivenV5x7(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withUserAgent((Object)42L)));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected string", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 42 to be of type STRING, but was of type Long.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 42 to be of type STRING, but was of type Long.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(since=@Version(major=6, minor=0))
    void shouldFailWhenInvalidUserAgentIsGiven(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withUserAgent((Object)42L)));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, ErrorUtil.useNewMessage((String)"08N06: General network protocol error.").whenLegacyFallbackTo("Illegal value for field \"user_agent\": Expected string"), GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"22N01: Expected the value 42 to be of type STRING, but was of type Long.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 42 to be of type STRING, but was of type Long.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }
}

