/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.assertj.core.api.Assertions;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.IllegalTransitionException;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.bolt.testing.util.ErrorUtil;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectAssertions;
import org.neo4j.gqlstatus.GqlExceptionLikeAssert;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

@CommunityStateMachineTestExtension
public class AuthenticationStateIT {
    @StateMachineTest(since=@Version(major=5, minor=1))
    public void shouldAcceptLogonMessageAndMoveToReadyState(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTHENTICATION);
        fsm.process(messages.logon(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.READY);
    }

    @StateMachineTest(since=@Version(major=5, minor=1), until=@Version(major=5, minor=6))
    public void shouldNotAcceptBeginMessage5x1(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTHENTICATION);
        IllegalTransitionException e = (IllegalTransitionException)org.junit.jupiter.api.Assertions.assertThrows(IllegalTransitionException.class, () -> fsm.process(messages.begin(), (ResponseHandler)recorder));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{ErrorUtil.useNewMessage((String)"08N06: General network protocol error.").whenLegacyFallbackTo("cannot be handled by a session in the AUTHENTICATION state.")});
        Assertions.assertThat((String)e.legacyMessage()).contains(new CharSequence[]{"cannot be handled by a session in the AUTHENTICATION state."});
    }

    @StateMachineTest(since=@Version(major=5, minor=7))
    public void shouldNotAcceptBeginMessageWithGqlstatus(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTHENTICATION);
        ((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)ErrorGqlStatusObjectAssertions.assertThatThrownBy(() -> fsm.process(messages.begin(), (ResponseHandler)recorder)).isInstanceOf(IllegalTransitionException.class)).hasMessage(ErrorUtil.useNewMessage((String)"08N06: General network protocol error.").whenLegacyFallbackTo("Message of type BeginMessage cannot be handled by a session in the AUTHENTICATION state."))).hasGqlStatus(GqlStatusInfoCodes.STATUS_08N06)).hasStatusDescription("error: connection exception - protocol error. General network protocol error.")).gqlCause().hasGqlStatus(GqlStatusInfoCodes.STATUS_08N10).hasStatusDescription("error: connection exception - invalid server state. Message BeginMessage cannot be handled by session in the 'AUTHENTICATION' state.");
    }
}

