/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.test.extension.handler.ConnectionTerminationRetryHandler;
import org.neo4j.bolt.test.extension.handler.ConnectionTimeoutRetryHandler;
import org.neo4j.bolt.test.extension.lifecycle.ServerInstanceManager;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.test.extension.resolver.connection.ConnectionProviderParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.SocketAddressParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.TransportConnectionParameterResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.extension.parameter.StaticParameterResolver;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

record BoltTestConfig(Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, ServerInstanceContext instanceContext, ConnectorTransport transport, TransportType transportType, BoltWire wire) implements TestTemplateInvocationContext
{
    public String getDisplayName(int invocationIndex) {
        return String.valueOf(this.wire.getProtocolVersion()) + " via " + this.transportType.name();
    }

    public List<Extension> getAdditionalExtensions() {
        TransportConnectionManager connectionManager = new TransportConnectionManager();
        return List.of(new ConnectionTerminationRetryHandler(), new ConnectionTimeoutRetryHandler(), new ServerInstanceManager(this.instanceContext), connectionManager, new StaticParameterResolver(BoltWire.class, (Object)this.wire), new StaticParameterResolver(TransportType.class, (Object)this.transportType), new SocketAddressParameterResolver(), new ConnectionProviderParameterResolver(connectionManager, this.wire, this.transport, this.transportType), new TransportConnectionParameterResolver(connectionManager, this.wire, this.transport, this.transportType));
    }
}

