/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.db;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class ServerInstanceContext {
    private final Function<ExtensionContext, TestDatabaseManagementServiceBuilder> databaseFactory;
    private final List<BiConsumer<ExtensionContext, TestDatabaseManagementServiceBuilder>> factoryCustomizers;
    private final List<BiConsumer<ExtensionContext, Map<Setting<?>, Object>>> settingsCustomizers;

    public ServerInstanceContext(Function<ExtensionContext, TestDatabaseManagementServiceBuilder> databaseFactory, List<BiConsumer<ExtensionContext, TestDatabaseManagementServiceBuilder>> factoryCustomizers, List<BiConsumer<ExtensionContext, Map<Setting<?>, Object>>> settingsCustomizers) {
        this.databaseFactory = databaseFactory;
        this.factoryCustomizers = factoryCustomizers;
        this.settingsCustomizers = settingsCustomizers;
    }

    public static ServerInstanceContext forExtensionContext(ExtensionContext context, Class<? extends TestDatabaseManagementServiceBuilder> fallbackType, List<BiConsumer<ExtensionContext, TestDatabaseManagementServiceBuilder>> factoryCustomizers, List<BiConsumer<ExtensionContext, Map<Setting<?>, Object>>> settingsCustomizers) {
        Function<ExtensionContext, TestDatabaseManagementServiceBuilder> databaseFactory = ServerInstanceContext.findDatabaseFactory(context, fallbackType);
        ArrayList discoveredSettingsCustomizers = new ArrayList(settingsCustomizers);
        discoveredSettingsCustomizers.addAll(ServerInstanceContext.findSettingsFunctions(context));
        return new ServerInstanceContext(databaseFactory, factoryCustomizers, discoveredSettingsCustomizers);
    }

    public static Function<ExtensionContext, TestDatabaseManagementServiceBuilder> findDatabaseFactory(ExtensionContext context, Function<ExtensionContext, TestDatabaseManagementServiceBuilder> fallbackSupplier) {
        Method function = AnnotationUtils.findAnnotatedMethods((Class)context.getRequiredTestClass(), FactoryFunction.class, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().findFirst().orElse(null);
        if (function != null && function.getParameterCount() == 0) {
            return instanceContext -> {
                MethodHandle handle = ServerInstanceContext.unreflectMethodHandle(function);
                try {
                    if (!Modifier.isStatic(function.getModifiers())) {
                        return handle.bindTo(instanceContext.getRequiredTestInstance()).invoke();
                    }
                    return handle.invoke();
                }
                catch (Throwable ex) {
                    Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName()), (Throwable)ex);
                    return null;
                }
            };
        }
        if (function != null) {
            Class<?> expectedFactoryType = function.getParameterTypes()[0];
            MethodHandle handle = ServerInstanceContext.unreflectMethodHandle(function);
            return instanceContext -> {
                TestDatabaseManagementServiceBuilder factory = (TestDatabaseManagementServiceBuilder)fallbackSupplier.apply((ExtensionContext)instanceContext);
                if (!expectedFactoryType.isInstance(factory)) {
                    Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName() + ": Expected factory of type " + expectedFactoryType.getName() + " but got " + factory.getClass().getName()));
                }
                try {
                    if (!Modifier.isStatic(function.getModifiers())) {
                        handle.bindTo(instanceContext.getRequiredTestInstance()).invoke(factory);
                    } else {
                        handle.invoke(factory);
                    }
                }
                catch (Throwable ex) {
                    Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName()), (Throwable)ex);
                }
                return factory;
            };
        }
        return fallbackSupplier;
    }

    public static Function<ExtensionContext, TestDatabaseManagementServiceBuilder> findDatabaseFactory(ExtensionContext context, Class<? extends TestDatabaseManagementServiceBuilder> fallbackType) {
        return ServerInstanceContext.findDatabaseFactory(context, (ExtensionContext instanceContext) -> {
            Constructor factoryConstructor;
            try {
                factoryConstructor = fallbackType.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                Assertions.fail((String)("Illegal database factory type " + fallbackType.getName() + ": Missing default no-args constructor - Try creating a @FactoryFunction method instead"), (Throwable)ex);
                return null;
            }
            try {
                return (TestDatabaseManagementServiceBuilder)factoryConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Assertions.fail((String)("Illegal database factory type " + fallbackType.getName() + ": Inaccessible default no-args constructor - Try creationg a @FactoryFunction method instead"), (Throwable)ex);
                return null;
            }
            catch (InstantiationException | InvocationTargetException ex) {
                Assertions.fail((String)("Failed to instantiate database factory type " + fallbackType.getName()), (Throwable)ex);
                return null;
            }
        });
    }

    private static MethodHandle unreflectMethodHandle(Method function) {
        MethodHandle handle;
        function.setAccessible(true);
        try {
            handle = MethodHandles.lookup().unreflect(function);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot access @FactoryFunction " + function.getName(), ex);
        }
        return handle;
    }

    public static List<BiConsumer<ExtensionContext, Map<Setting<?>, Object>>> findSettingsFunctions(ExtensionContext context) {
        return AnnotationUtils.findAnnotatedMethods((Class)context.getRequiredTestClass(), SettingsFunction.class, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).stream().map(method -> ServerInstanceContext.wrapSettingsFunction(method)).toList();
    }

    private static BiConsumer<ExtensionContext, Map<Setting<?>, Object>> wrapSettingsFunction(Method function) {
        MethodHandle handle = ServerInstanceContext.unreflectMethodHandle(function);
        return (context, settings) -> {
            try {
                if (!Modifier.isStatic(function.getModifiers())) {
                    handle.bindTo(context.getRequiredTestInstance()).invoke((Map)settings);
                } else {
                    handle.invoke((Map)settings);
                }
            }
            catch (Throwable ex) {
                Assertions.fail((String)"Failed to invoke settings function", (Throwable)ex);
            }
        };
    }

    public Neo4jWithSocket configure(ExtensionContext context) {
        Neo4jWithSocket neo4j = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)context);
        if (neo4j == null) {
            throw new IllegalStateException("Illegal test configuration: Expected @Neo4jWithSocket extension to be present");
        }
        neo4j.setGraphDatabaseFactory(this.databaseFactory.apply(context));
        neo4j.setConfigure(config -> {
            BoltProtocol.installed().stream().map(BoltProtocol::version).max(ProtocolVersion::compareTo).ifPresent(latest -> config.put(BoltConnectorInternalSettings.max_protocol_version, new BoltConnectorInternalSettings.ConfiguredProtocolVersion(Integer.valueOf(latest.major()), Integer.valueOf(latest.minor()))));
            this.settingsCustomizers.forEach(customizer -> customizer.accept(context, config));
        });
        return neo4j;
    }

    public void stop(ExtensionContext context) {
        Neo4jWithSocket neo4j = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)context);
        if (neo4j != null) {
            neo4j.shutdownDatabase();
        }
    }
}

