/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.lifecycle;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.TransportType;

public class TransportConnectionManager
implements AfterEachCallback {
    private final Lock lock = new ReentrantLock();
    private final List<BoltTestConnection> activeConnections = new ArrayList<BoltTestConnection>();

    public void afterEach(ExtensionContext extensionContext) {
        this.lock.lock();
        try {
            this.activeConnections.forEach(connection -> {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.activeConnections.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoltTestConnection acquire(ConnectorTransport transport, SocketAddress address, TransportType transportType) {
        BoltTestConnection connection = transportType.getFactory().create(transport, address);
        this.lock.lock();
        try {
            this.activeConnections.add(connection);
        }
        finally {
            this.lock.unlock();
        }
        return connection;
    }
}

