/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.resolver.connection;

import java.net.SocketAddress;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.test.connection.initializer.ConnectionInitializer;
import org.neo4j.bolt.test.connection.resolver.AddressResolver;
import org.neo4j.bolt.test.connection.resolver.DefaultAddressResolver;
import org.neo4j.bolt.test.connection.transport.TransportSelector;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;

public abstract class AbstractConnectionInitializingParameterResolver
implements ParameterResolver {
    private final TransportConnectionManager connectionManager;
    private final BoltWire wire;
    private final ConnectorTransport transport;
    private final TransportType transportType;

    public AbstractConnectionInitializingParameterResolver(TransportConnectionManager connectionManager, BoltWire wire, ConnectorTransport transport, TransportType transportType) {
        this.connectionManager = connectionManager;
        this.wire = wire;
        this.transport = transport;
        this.transportType = transportType;
    }

    protected TransportType getTransportType(ExtensionContext extensionContext, ParameterContext context) {
        return TransportSelector.findTransportOverride(context).orElse(this.transportType);
    }

    protected BoltTestConnection acquireConnection(ExtensionContext extensionContext, ParameterContext context) {
        Neo4jWithSocket server = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)extensionContext);
        AddressResolver resolver = AddressResolver.findResolver(context).orElseGet(DefaultAddressResolver::new);
        List<ConnectionInitializer> initializers = ConnectionInitializer.findInitializers(context);
        TransportType transportType = this.getTransportType(extensionContext, context);
        SocketAddress address = resolver.resolve(extensionContext, context, server, transportType);
        BoltTestConnection connection = this.connectionManager.acquire(this.transport, address, transportType);
        try {
            for (ConnectionInitializer initializer : initializers) {
                initializer.initialize(extensionContext, context, this.wire, connection);
            }
        }
        catch (ParameterResolutionException ex) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        return connection;
    }
}

