/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.throttle;

import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.bolt.runtime.throttle.ChannelReadThrottleHandler;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ReadThrottleIT {
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;

    @FactoryFunction
    void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark, 8);
        settings.put(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark, 3);
    }

    @BeforeEach
    void prepare() throws ProcedureException {
        ServerUtil.installSleepProcedure(this.server);
    }

    @AfterEach
    void cleanup() {
        this.internalLogProvider.clear();
    }

    @TransportTest
    void largeNumberOfSlowRunningJobsShouldChangeAutoReadState(BoltWire wire, @Authenticated BoltTestConnection connection) throws IOException {
        int i;
        int numberOfRunDiscardPairs = 20;
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            connection.send(wire.run("CALL boltissue.sleep(50)")).send(wire.discard());
        }
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            try {
                LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(ChannelReadThrottleHandler.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Disabling message processing"});
                LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(ChannelReadThrottleHandler.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Enabling message processing"});
                return;
            }
            catch (AssertionError assertionError) {
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
                continue;
            }
        }
        throw new AssertionError((Object)"Read throttle was not applied");
    }
}

