/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tls;

import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Assertions;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Connected;
import org.neo4j.bolt.test.annotation.connection.transport.ExcludeTransport;
import org.neo4j.bolt.test.annotation.connection.transport.IncludeTransport;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.client.error.BoltTestClientClosedException;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class RequiredTransportSecurityIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.REQUIRED);
    }

    @TransportTest
    @ExcludeTransport(value={TransportType.LOCAL, TransportType.UNIX, TransportType.WEBSOCKET_TLS, TransportType.TCP_TLS})
    void shouldCloseUnencryptedConnectionOnHandshakeWhenEncryptionIsRequired(BoltWire wire, @Connected ConnectionProvider connectionProvider) throws IOException {
        BoltTestConnection connection = connectionProvider.create();
        try {
            connection.connect();
            connection.send(wire.getProtocolVersion());
        }
        catch (RuntimeException e) {
            Assertions.assertInstanceOf(BoltTestClientClosedException.class, (Object)e);
        }
        ((BoltConnectionAssertions)BoltConnectionAssertions.assertThat((BoltTestConnection)connection).isNot(RequiredTransportSecurityIT.protocolNegotiated())).isEventuallyTerminated();
    }

    @TransportTest
    @IncludeTransport(value={TransportType.LOCAL, TransportType.UNIX, TransportType.WEBSOCKET_TLS, TransportType.TCP_TLS})
    void shouldHandshakeOnSafeConnectionsWhenEncryptionIsRequired(BoltWire wire, @Connected BoltTestConnection connection) throws IOException {
        connection.send(wire.getProtocolVersion());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).is(RequiredTransportSecurityIT.protocolNegotiated());
        connection.close();
    }

    private static Condition<BoltTestConnection> protocolNegotiated() {
        return new Condition(c -> {
            try {
                c.receiveNegotiatedVersion();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
        }, "shouldn't receive negotiated version", new Object[0]);
    }
}

