/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.test.rule.SuppressOutput;

public class BoltConfigIT
extends AbstractBoltTransportsTest {
    private static final String ANOTHER_CONNECTOR_KEY = "1";
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> {
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new BoltConnector((String)"bolt").address.name(), "localhost:0");
        settings.put(new BoltConnector((String)ANOTHER_CONNECTOR_KEY).type.name(), "BOLT");
        settings.put(new BoltConnector((String)ANOTHER_CONNECTOR_KEY).enabled.name(), "true");
        settings.put(new BoltConnector((String)ANOTHER_CONNECTOR_KEY).address.name(), "localhost:0");
        settings.put(new BoltConnector((String)ANOTHER_CONNECTOR_KEY).encryption_level.name(), BoltConnector.EncryptionLevel.REQUIRED.name());
    });
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldSupportMultipleConnectors() throws Throwable {
        HostnamePort address0 = this.server.lookupConnector("bolt");
        this.assertConnectionAccepted(address0, this.newConnection());
        HostnamePort address1 = this.server.lookupConnector(ANOTHER_CONNECTOR_KEY);
        this.assertConnectionRejected(address1, this.newConnection());
    }

    private void assertConnectionRejected(HostnamePort address, TransportConnection client) throws Exception {
        client.connect(address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void assertConnectionAccepted(HostnamePort address, TransportConnection client) throws Exception {
        client.connect(address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", Collections.emptyMap())}));
        MatcherAssert.assertThat((Object)client, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
    }
}

