/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.StateMachineMessage;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.v1.messaging.Init;
import org.neo4j.bolt.v1.messaging.Run;
import org.neo4j.bolt.v1.runtime.integration.SessionRule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

public class BoltConnectionAuthIT {
    private static final String USER_AGENT = "BoltConnectionAuthIT/0.0";
    private static final BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
    @Rule
    public SessionRule env = new SessionRule().withAuthEnabled(true);

    @Test
    public void shouldGiveCredentialsExpiredStatusOnExpiredCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        Init init = new Init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}));
        machine.process((StateMachineMessage)init, (BoltResponseHandler)recorder);
        machine.process((StateMachineMessage)new Run("CREATE ()", VirtualValues.EMPTY_MAP), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithMetadata((String)"credentials_expired", (AnyValue)Values.TRUE));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Security.CredentialsExpired));
    }

    @Test
    public void shouldGiveKernelVersionOnInit() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        String version = "Neo4j/" + Version.getNeo4jVersion();
        Init init = new Init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j"}));
        machine.process((StateMachineMessage)init, (BoltResponseHandler)recorder);
        machine.process((StateMachineMessage)new Run("CREATE ()", VirtualValues.EMPTY_MAP), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeededWithMetadata((String)"server", (AnyValue)Values.stringValue((String)version)));
    }

    @Test
    public void shouldCloseConnectionAfterAuthenticationFailure() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        Init init = new Init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "j4oen"}));
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process((StateMachineMessage)init, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Security.Unauthorized));
    }

    @Test
    public void shouldBeAbleToActOnSessionWhenUpdatingCredentials() throws Throwable {
        BoltStateMachine machine = this.env.newMachine(boltChannel);
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        Init message = new Init(USER_AGENT, MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret"}));
        machine.process((StateMachineMessage)message, (BoltResponseHandler)recorder);
        machine.process((StateMachineMessage)new Run("CREATE ()", VirtualValues.EMPTY_MAP), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
    }
}

