/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.Version;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class AuthenticationIT
extends AbstractBoltTransportsTest {
    protected EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    protected Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    private HostnamePort address;
    private final String version = "Neo4j/" + Version.getNeo4jVersion();

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestGraphDatabaseFactory();
    }

    protected Consumer<Map<String, String>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "true");
    }

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldRespondWithCredentialsExpiredOnFirstUse() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.verifyConnectionOpen();
    }

    private void verifyConnectionOpen() throws IOException {
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.reset()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailIfWrongCredentials() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfWrongCredentialsFollowingSuccessfulLogin() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "wrong", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenWrongType() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", Collections.singletonList("neo4j"), "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingKey() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "this-should-have-been-credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `credentials`")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenMissingScheme() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, missing key `scheme`")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailIfMalformedAuthTokenUnknownScheme() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "unknown"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"Unsupported authentication token, scheme 'unknown' is not supported.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailDifferentlyIfTooManyFailedAuthAttempts() throws Exception {
        long timeout = System.currentTimeMillis() + 60000L;
        FailureMessage failureMessage = null;
        block5: while (failureMessage == null) {
            int i;
            if (System.currentTimeMillis() > timeout) {
                Assert.fail((String)"Timed out waiting for the authentication failure to occur.");
            }
            ExecutorService executor = Executors.newFixedThreadPool(10);
            ArrayList<CompletableFuture<FailureMessage>> futures = new ArrayList<CompletableFuture<FailureMessage>>();
            for (i = 0; i < 10; ++i) {
                futures.add(CompletableFuture.supplyAsync(this::collectAuthFailureOnFailedAuth, executor));
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                for (i = 0; i < futures.size(); ++i) {
                    FailureMessage recordedMessage = (FailureMessage)((CompletableFuture)futures.get(i)).get();
                    if (recordedMessage == null) continue;
                    failureMessage = recordedMessage;
                    continue block5;
                }
            }
            catch (TimeoutException timeoutException) {}
            continue;
            finally {
                executor.shutdown();
            }
        }
        MatcherAssert.assertThat((Object)failureMessage.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.AuthenticationRateLimit));
        MatcherAssert.assertThat((Object)failureMessage.message(), (Matcher)CoreMatchers.containsString((String)"The client has provided incorrect authentication details too many times in a row."));
    }

    @Test
    public void shouldBeAbleToUpdateCredentials() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAuthenticatedAfterUpdatingCredentials() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "new_credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAbleToChangePasswordUsingBuiltInProcedure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "secret")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        this.reconnect();
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "secret", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAuthenticatedAfterChangePasswordUsingBuiltInProcedure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "secret")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailWhenReusingTheSamePassword() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "neo4j")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, (String)"Old password and new password cannot be the same.")}));
        this.connection.send(this.util.chunk(new RequestMessage[]{AckFailureMessage.ackFailure(), RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "abc")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailWhenSubmittingEmptyPassword() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, (String)"A password cannot be empty.")}));
        this.connection.send(this.util.chunk(new RequestMessage[]{AckFailureMessage.ackFailure(), RunMessage.run((String)"CALL dbms.security.changePassword", (MapValue)this.singletonMap("password", "abc")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgIgnored(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldNotBeAbleToReadWhenPasswordChangeRequired() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "neo4j", "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Map)MapUtil.map((Object[])new Object[]{"credentials_expired", true, "server", this.version}))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.CredentialsExpired, (String)"The credentials you provided were valid, but must be changed before you can use this instance.")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }

    private FailureMessage collectAuthFailureOnFailedAuth() {
        FailureMsgMatcher failureRecorder = new FailureMsgMatcher();
        TransportConnection connection = null;
        try {
            connection = this.newConnection();
            connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN", "scheme", "basic"}))}));
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{failureRecorder}));
            MatcherAssert.assertThat((Object)connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return failureRecorder.specialMessage;
    }

    class FailureMsgMatcher
    extends TypeSafeMatcher<ResponseMessage> {
        FailureMessage specialMessage;

        FailureMsgMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("FAILURE");
        }

        protected boolean matchesSafely(ResponseMessage t) {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(FailureMessage.class));
            FailureMessage msg = (FailureMessage)t;
            if (!msg.status().equals(Status.Security.Unauthorized) || !msg.message().contains("The client is unauthorized due to authentication failure.")) {
                this.specialMessage = msg;
            }
            return true;
        }

        public boolean gotSpecialMessage() {
            return this.specialMessage != null;
        }
    }
}

