/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.bolt.runtime.BoltConnectionReadLimiter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.virtual.MapValue;

public class BoltChannelAutoReadLimiterIT {
    private AssertableLogProvider logProvider;
    private EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        this.logProvider = new AssertableLogProvider();
        factory.setInternalLogProvider((LogProvider)this.logProvider);
        return factory;
    }

    protected Consumer<Map<String, String>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false");
    }

    @Before
    public void setup() throws Exception {
        BoltChannelAutoReadLimiterIT.installSleepProcedure(this.server.graphDatabaseService());
        this.address = this.server.lookupDefaultConnector();
        this.connection = new SocketConnection();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV1());
    }

    @Test
    public void largeNumberOfSlowRunningJobsShouldChangeAutoReadState() throws Exception {
        int i;
        int numberOfRunDiscardPairs = 1000;
        String largeString = StringUtils.repeat((String)" ", (int)8192);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", Collections.emptyMap())}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            this.connection.send(this.util.chunk(new RequestMessage[]{RunMessage.run((String)"CALL boltissue.sleep( $data )", (MapValue)ValueUtils.asMapValue(Collections.singletonMap("data", largeString))), DiscardAllMessage.discardAll()}));
        }
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        }
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltConnectionReadLimiter.class).warn(CoreMatchers.containsString((String)"disabled"), new Object[]{CoreMatchers.anything(), CoreMatchers.anything()})});
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltConnectionReadLimiter.class).warn(CoreMatchers.containsString((String)"enabled"), new Object[]{CoreMatchers.anything(), CoreMatchers.anything()})});
    }

    private static void installSleepProcedure(GraphDatabaseService db) throws ProcedureException {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        ((Procedures)dbApi.getDependencyResolver().resolveDependency(Procedures.class)).register((CallableProcedure)new CallableProcedure.BasicProcedure(ProcedureSignature.procedureSignature((String[])new String[]{"boltissue", "sleep"}).in("data", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out(ProcedureSignature.VOID).build()){

            public RawIterator<Object[], ProcedureException> apply(Context context, Object[] objects, ResourceTracker resourceTracker) throws ProcedureException {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Interrupted", new Object[0]);
                }
                return RawIterator.empty();
            }
        });
    }
}

