/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v2.transport.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class UnsupportedStructTypesV2IT {
    private static final String USER_AGENT = "TestClient/2.0";
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));
    @Parameterized.Parameter
    public Class<? extends TransportConnection> connectionClass;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    @Parameterized.Parameters(name="{0}")
    public static List<Class<? extends TransportConnection>> transports() {
        return Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    }

    @Before
    public void setup() throws Exception {
        this.address = this.server.lookupDefaultConnector();
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());
    }

    @After
    public void cleanup() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldFailWhenPoint2DIsSentWithInvalidCrsId() throws Exception {
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.POINT_2D.signature());
            packer.pack((AnyValue)Values.of((Object)5));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
        }), "Unable to construct Point value: `Unknown coordinate reference system code: 5`");
    }

    @Test
    public void shouldFailWhenPoint3DIsSentWithInvalidCrsId() throws Exception {
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(4, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)1200));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
            packer.pack((AnyValue)Values.of((Object)5.905));
        }), "Unable to construct Point value: `Unknown coordinate reference system code: 1200`");
    }

    @Test
    public void shouldFailWhenPoint2DDimensionsDoNotMatch() throws Exception {
        this.testDisconnectWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)CoordinateReferenceSystem.Cartesian_3D.getCode()));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
        }), "Unable to construct Point value: `Cannot create point, CRS cartesian-3d expects 3 dimensions, but got coordinates [3.15, 4.012]`");
    }

    @Test
    public void shouldFailWhenPoint3DDimensionsDoNotMatch() throws Exception {
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(4, StructType.POINT_3D.signature());
            packer.pack((AnyValue)Values.of((Object)CoordinateReferenceSystem.Cartesian.getCode()));
            packer.pack((AnyValue)Values.of((Object)3.15));
            packer.pack((AnyValue)Values.of((Object)4.012));
            packer.pack((AnyValue)Values.of((Object)5.905));
        }), "Unable to construct Point value: `Cannot create point, CRS cartesian expects 2 dimensions, but got coordinates [3.15, 4.012, 5.905]`");
    }

    @Test
    public void shouldFailWhenZonedDateTimeZoneIdIsNotKnown() throws Exception {
        this.testFailureWithUnpackableValue((ThrowingConsumer<Neo4jPack.Packer, IOException>)((ThrowingConsumer)packer -> {
            packer.packStructHeader(3, StructType.DATE_TIME_WITH_ZONE_NAME.signature());
            packer.pack((AnyValue)Values.of((Object)0));
            packer.pack((AnyValue)Values.of((Object)0));
            packer.pack((AnyValue)Values.of((Object)"Europe/Marmaris"));
        }), "Unable to construct ZonedDateTime value: `Unknown time-zone ID: Europe/Marmaris`");
    }

    private void testFailureWithUnpackableValue(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker, String expectedMessage) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)USER_AGENT, Collections.emptyMap())}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWith(valuePacker)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Statement.TypeError, (String)expectedMessage)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void testDisconnectWithUnpackableValue(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker, String expectedMessage) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(new RequestMessage[]{InitMessage.init((String)USER_AGENT, Collections.emptyMap())}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWith(valuePacker)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWith(ThrowingConsumer<Neo4jPack.Packer, IOException> valuePacker) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPackV2().newPacker((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        valuePacker.accept((Object)packer);
        return out.bytes();
    }
}

