/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.integration.BoltV3TransportBase;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class BoltV3TransportIT
extends BoltV3TransportBase {
    @Test
    public void shouldNegotiateProtocolV3() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 0L, 0L, 0L)).send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TestClient/3.0"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasKey((Object)"server"), (Matcher)Matchers.hasKey((Object)"connection_id")))}));
    }

    @Test
    public void shouldNegotiateProtocolV3WhenClientSupportsBothV1V2AndV3() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 2L, 1L, 0L)).send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "TestClient/3.0"}))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
    }

    @Test
    public void shouldRunSimpleStatement() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE}));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L)), CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L)), CoreMatchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)3L)), CoreMatchers.equalTo((Object)Values.longValue((long)9L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"t_last"), (Matcher)Matchers.hasKey((Object)"bookmark")))}));
    }

    @Test
    public void shouldRespondWithMetadataToDiscardAll() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), DiscardAllMessage.INSTANCE}));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"t_last"), (Matcher)Matchers.hasKey((Object)"bookmark")))}));
    }

    @Test
    public void shouldRunSimpleStatementInTx() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE, CommitMessage.COMMIT_MESSAGE}));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L)), CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L)), CoreMatchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)3L)), CoreMatchers.equalTo((Object)Values.longValue((long)9L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"t_last"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"bookmark")))), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasKey((Object)"bookmark")}))}));
    }

    @Test
    public void shouldAllowRollbackSimpleStatementInTx() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE, RollbackMessage.ROLLBACK_MESSAGE}));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L)), CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L)), CoreMatchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)3L)), CoreMatchers.equalTo((Object)Values.longValue((long)9L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"t_last"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"bookmark")))), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAbleToRunQueryAfterReset() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("QINVALID"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("Invalid input 'Q': expected <init> (line 1, column 1 (offset: 0))%n\"QINVALID\"%n ^", new Object[0])), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldRunProcedure() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n:Test {age: 2}) RETURN n.age AS age"), PullAllMessage.INSTANCE}));
        Matcher ageMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("age")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)ageMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L))})), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CALL db.labels() YIELD label"), PullAllMessage.INSTANCE}));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("label")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"t_first"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.stringValue((String)"Test"))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedNodes() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n:Test) DELETE n RETURN n"), PullAllMessage.INSTANCE}));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("n")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"t_first")))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedRelationships() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"), PullAllMessage.INSTANCE}));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("r")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"t_first")))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 11, 177, 113, 145, 181, 82, 0, 0, 1, 129, 84, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldNotLeakStatsToNextStatement() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CREATE (n)"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Matcher typeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)typeMatcher, (Matcher)Matchers.hasKey((Object)"t_last")))}));
    }

    private byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Test
    public void shouldFailNicelyOnNullKeysInMap() throws Throwable {
        HashMap params = new HashMap();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("RETURN {p}", ValueUtils.asMapValue(params)), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{ResetMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailNicelyWhenDroppingUnknownIndex() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("DROP INDEX on :Movie12345(id)"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Schema.IndexDropFailed, (String)"Unable to drop index on :Movie12345(id): No such INDEX ON :Movie12345(id)."), MessageMatchers.msgIgnored()}));
    }

    @Test
    public void shouldSetTxMetadata() throws Throwable {
        this.negotiateBoltV3();
        Map txMetadata = MapUtil.map((Object[])new Object[]{"who-is-your-boss", "Molly-mostly-white"});
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(meta), new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)this.server.graphDatabaseService();
        Set txHandles = ((KernelTransactions)gdb.getDependencyResolver().resolveDependency(KernelTransactions.class)).activeTransactions();
        MatcherAssert.assertThat((Object)txHandles.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        for (KernelTransactionHandle txHandle : txHandles) {
            MatcherAssert.assertThat((Object)txHandle.getMetaData(), (Matcher)CoreMatchers.equalTo((Object)txMetadata));
        }
        this.connection.send(this.util.chunk(new RequestMessage[]{RollbackMessage.ROLLBACK_MESSAGE}));
    }

    @Test
    public void shouldSendFailureMessageForBeginWithInvalidBookmark() throws Exception {
        this.negotiateBoltV3();
        String bookmarkString = "Not a good bookmark for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"bookmarks", Collections.singletonList(bookmarkString)});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Transaction.InvalidBookmark, (String)bookmarkString)}));
    }

    @Test
    public void shouldSendFailureMessageForBeginWithInvalidTransactionTimeout() throws Exception {
        this.negotiateBoltV3();
        String txTimeout = "Tx timeout can't be a string for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_timeout", txTimeout});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)txTimeout)}));
    }

    @Test
    public void shouldSendFailureMessageForBeginWithInvalidTransactionMetadata() throws Exception {
        this.negotiateBoltV3();
        String txMetadata = "Tx metadata can't be a string for BEGIN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.beginMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)txMetadata)}));
    }

    @Test
    public void shouldSendFailureMessageForRunWithInvalidBookmark() throws Exception {
        this.negotiateBoltV3();
        String bookmarkString = "Not a good bookmark for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"bookmarks", Collections.singletonList(bookmarkString)});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Transaction.InvalidBookmark, (String)bookmarkString)}));
    }

    @Test
    public void shouldSendFailureMessageForRunWithInvalidTransactionTimeout() throws Exception {
        this.negotiateBoltV3();
        String txTimeout = "Tx timeout can't be a string for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_timeout", txTimeout});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)txTimeout)}));
    }

    @Test
    public void shouldSendFailureMessageForRunWithInvalidTransactionMetadata() throws Exception {
        this.negotiateBoltV3();
        String txMetadata = "Tx metadata can't be a string for RUN";
        Map metadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        this.connection.send(this.util.chunk(32, (byte[][])new byte[][]{this.runMessage(metadata)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)txMetadata)}));
    }

    private byte[] beginMessage(Map<String, Object> metadata) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.util.getNeo4jPack().newPacker((PackOutput)out);
        packer.packStructHeader(1, (byte)17);
        packer.pack((AnyValue)ValueUtils.asMapValue(metadata));
        return out.bytes();
    }

    private byte[] runMessage(Map<String, Object> metadata) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.util.getNeo4jPack().newPacker((PackOutput)out);
        packer.packStructHeader(3, (byte)16);
        packer.pack("RETURN 1");
        packer.pack((AnyValue)VirtualValues.EMPTY_MAP);
        packer.pack((AnyValue)ValueUtils.asMapValue(metadata));
        return out.bytes();
    }
}

