/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailedState;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v3.runtime.TransactionStreamingState;
import org.neo4j.bolt.v3.runtime.integration.BoltStateMachineStateTestBase;
import org.neo4j.kernel.api.exceptions.Status;

class TransactionReadyStateIT
extends BoltStateMachineStateTestBase {
    TransactionReadyStateIT() {
    }

    @Test
    void shouldMoveToStreamingOnRun_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        Assertions.assertTrue((boolean)response.hasMetadata("fields"));
        Assertions.assertTrue((boolean)response.hasMetadata("t_first"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionStreamingState.class));
    }

    @Test
    void shouldMoveToReadyOnCommit_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)CommitMessage.COMMIT_MESSAGE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeeded());
        Assertions.assertTrue((boolean)response.hasMetadata("bookmark"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(ReadyState.class));
    }

    @Test
    void shouldMoveToReadyOnRollback_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)RollbackMessage.ROLLBACK_MESSAGE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(ReadyState.class));
    }

    @Test
    void shouldMoveToFailedOnRun_fail() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseHandler handler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Error!")}).when((Object)handler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        machine.process((RequestMessage)new RunMessage("A cypher query"), handler);
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
    }

    @Test
    void shouldMoveToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxReadyState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
        Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() throws BoltIOException {
        return Stream.of(TransactionReadyStateIT.newHelloMessage(), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE, new BeginMessage(), GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private BoltStateMachineV3 getBoltStateMachineInTxReadyState() throws BoltConnectionFatality, BoltIOException {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)TransactionReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }
}

