/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v3.runtime.integration.BoltStateMachineStateTestBase;

class InterruptedStateIT
extends BoltStateMachineStateTestBase {
    InterruptedStateIT() {
    }

    @Test
    void shouldMoveReadyOnReset_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(ReadyState.class));
    }

    @Test
    void shouldStayInInterruptedOnMoreReset() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        machine.interrupt();
        machine.interrupt();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(ReadyState.class));
    }

    @Test
    void shouldStayInInterruptedOnInterruptedSignal() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException, BoltConnectionFatality {
        BoltStateMachineV3 machine = this.getBoltStateMachineInInterruptedState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process(message, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    private BoltStateMachineV3 getBoltStateMachineInInterruptedState() throws BoltConnectionFatality {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)InterruptedStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
        return machine;
    }

    private static Stream<RequestMessage> illegalV3Messages() throws BoltIOException {
        return Stream.of(InterruptedStateIT.newHelloMessage(), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE, new BeginMessage(), CommitMessage.COMMIT_MESSAGE, RollbackMessage.ROLLBACK_MESSAGE, new RunMessage("A cypher query"), GoodbyeMessage.GOODBYE_MESSAGE);
    }
}

