/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;

public class ConcurrentAccessIT
extends AbstractBoltTransportsTest {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRunSimpleStatement() throws Throwable {
        int numWorkers = 5;
        int numRequests = 1000;
        List<Callable<Void>> workers = this.createWorkers(numWorkers, numRequests);
        ExecutorService exec = Executors.newFixedThreadPool(numWorkers);
        try {
            for (Future<Void> f : exec.invokeAll(workers)) {
                f.get(60L, TimeUnit.SECONDS);
            }
        }
        finally {
            exec.shutdownNow();
            exec.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private List<Callable<Void>> createWorkers(int numWorkers, int numRequests) throws Exception {
        LinkedList<Callable<Void>> workers = new LinkedList<Callable<Void>>();
        for (int i = 0; i < numWorkers; ++i) {
            workers.add(this.newWorker(numRequests));
        }
        return workers;
    }

    private Callable<Void> newWorker(final int iterationsToRun) throws Exception {
        return new Callable<Void>(){
            private final byte[] init;
            private final byte[] createAndRollback;
            private final byte[] matchAll;
            {
                this.init = ConcurrentAccessIT.this.util.chunk(new RequestMessage[]{new InitMessage("TestClient", Collections.emptyMap())});
                this.createAndRollback = ConcurrentAccessIT.this.util.chunk(new RequestMessage[]{new RunMessage("BEGIN"), PullAllMessage.INSTANCE, new RunMessage("CREATE (n)"), PullAllMessage.INSTANCE, new RunMessage("ROLLBACK"), PullAllMessage.INSTANCE});
                this.matchAll = ConcurrentAccessIT.this.util.chunk(new RequestMessage[]{new RunMessage("MATCH (n) RETURN n"), PullAllMessage.INSTANCE});
            }

            @Override
            public Void call() throws Exception {
                TransportConnection client = ConcurrentAccessIT.this.newConnection();
                client.connect(ConcurrentAccessIT.this.server.lookupDefaultConnector()).send(ConcurrentAccessIT.this.util.defaultAcceptedVersions());
                MatcherAssert.assertThat((Object)client, (Matcher)ConcurrentAccessIT.this.util.eventuallyReceivesSelectedProtocolVersion());
                this.init(client);
                for (int i = 0; i < iterationsToRun; ++i) {
                    this.createAndRollback(client);
                }
                return null;
            }

            private void init(TransportConnection client) throws Exception {
                client.send(this.init);
                MatcherAssert.assertThat((Object)client, (Matcher)ConcurrentAccessIT.this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
            }

            private void createAndRollback(TransportConnection client) throws Exception {
                client.send(this.createAndRollback);
                Matcher entryMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
                Matcher messageMatcher = CoreMatchers.allOf((Matcher)entryMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"));
                MatcherAssert.assertThat((Object)client, (Matcher)ConcurrentAccessIT.this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)messageMatcher), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)messageMatcher), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)messageMatcher), MessageMatchers.msgSuccess()}));
                client.send(this.matchAll);
                Matcher fieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("n")));
                MatcherAssert.assertThat((Object)client, (Matcher)ConcurrentAccessIT.this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)fieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgSuccess()}));
            }
        };
    }
}

