/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.Collections;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.ReadyState;
import org.neo4j.bolt.v3.runtime.integration.BoltStateMachineStateTestBase;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;

class ConnectedStateIT
extends BoltStateMachineStateTestBase {
    ConnectedStateIT() {
    }

    @Test
    void shouldHandleHelloMessage() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)ConnectedStateIT.newHelloMessage(), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeededWithMetadata((String)"server", (String)("Neo4j/" + Version.getNeo4jVersion())));
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeededWithMetadata((String)"connection_id", (String)"conn-v3-test-boltchannel-id"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(ReadyState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV2Messages"})
    void shouldCloseConnectionOnIllegalV2Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException {
        BoltStateMachineV3 machine = this.newStateMachine();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
        Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() throws BoltIOException {
        return Stream.of(new RunMessage("RETURN 1", EMPTY_PARAMS, EMPTY_PARAMS), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE, new BeginMessage(), CommitMessage.COMMIT_MESSAGE, RollbackMessage.ROLLBACK_MESSAGE, InterruptSignal.INSTANCE, ResetMessage.INSTANCE, GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private static Stream<RequestMessage> illegalV2Messages() {
        return Stream.of(new org.neo4j.bolt.v1.messaging.request.RunMessage("RETURN 1", EMPTY_PARAMS), new InitMessage("BoltConnectionIT/0.0", Collections.emptyMap()));
    }
}

