/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class UnsupportedStructTypesV1IT {
    private static final String USER_AGENT = "TestClient/1.0";
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));
    @Parameterized.Parameter
    public Class<? extends TransportConnection> connectionClass;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    @Parameterized.Parameters(name="{0}")
    public static List<Class<? extends TransportConnection>> transports() {
        return Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    }

    @Before
    public void setup() throws Exception {
        this.address = this.server.lookupDefaultConnector();
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV1());
    }

    @After
    public void cleanup() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldFailWhenPoint2DIsSentWithRun() throws Exception {
        this.testFailureWithV2Value((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.2, 3.4}), "Point");
    }

    @Test
    public void shouldFailWhenPoint3DIsSentWithRun() throws Exception {
        this.testFailureWithV2Value((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{1.2, 3.4, 4.5}), "Point");
    }

    @Test
    public void shouldFailWhenDurationIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)Duration.ofDays(10L)), "Duration");
    }

    @Test
    public void shouldFailWhenDateIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)LocalDate.now()), "Date");
    }

    @Test
    public void shouldFailWhenLocalTimeIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)LocalTime.now()), "LocalTime");
    }

    @Test
    public void shouldFailWhenLocalDateTimeIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)LocalDateTime.now()), "LocalDateTime");
    }

    @Test
    public void shouldFailWhenOffsetTimeIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)OffsetTime.now()), "OffsetTime");
    }

    @Test
    public void shouldFailWhenOffsetDateTimeIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)OffsetDateTime.now()), "OffsetDateTime");
    }

    @Test
    public void shouldFailWhenZonedDateTimeIsSentWithRun() throws Exception {
        this.testFailureWithV2Value(ValueUtils.of((Object)ZonedDateTime.now()), "ZonedDateTime");
    }

    private void testFailureWithV2Value(AnyValue value, String description) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(new RequestMessage[]{new InitMessage(USER_AGENT, Collections.emptyMap())}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(64, (byte[][])new byte[][]{this.createRunWithV2Value(value)}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Statement.TypeError, (String)(description + " values cannot be unpacked with this version of bolt."))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWithV2Value(AnyValue value) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPackV2().newPacker((PackOutput)out);
        packer.packStructHeader(2, (byte)16);
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.pack(value);
        return out.bytes();
    }
}

