/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TestNotification;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.storable.Values;

public class TransportSessionIT
extends AbstractBoltTransportsTest {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));
    private HostnamePort address;

    @Before
    public void setup() {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldNegotiateProtocolVersion() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
    }

    @Test
    public void shouldReturnNilOnNoApplicableVersion() throws Throwable {
        this.connection.connect(this.address).send(this.util.acceptedVersions(1337L, 0L, 0L, 0L));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 0}));
    }

    @Test
    public void shouldRunSimpleStatement() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L)), CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L)), CoreMatchers.equalTo((Object)Values.longValue((long)4L))})), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)3L)), CoreMatchers.equalTo((Object)Values.longValue((long)9L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"result_consumed_after")))}));
    }

    @Test
    public void shouldRespondWithMetadataToDiscardAll() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared"), DiscardAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        Matcher entryTypeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryTypeMatcher, (Matcher)Matchers.hasKey((Object)"result_consumed_after")))}));
    }

    @Test
    public void shouldBeAbleToRunQueryAfterAckFailure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("QINVALID"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("Invalid input 'Q': expected <init> (line 1, column 1 (offset: 0))%n\"QINVALID\"%n ^", new Object[0])), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{AckFailureMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldRunProcedure() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("CREATE (n:Test {age: 2}) RETURN n.age AS age"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher ageMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("age")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)ageMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)2L))})), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("CALL db.labels() YIELD label"), PullAllMessage.INSTANCE}));
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("label")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)Values.stringValue((String)"Test"))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedNodes() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("CREATE (n:Test) DELETE n RETURN n"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("n")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after")))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 8, 177, 113, 145, 179, 78, 0, 144, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldHandleDeletedRelationships() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("CREATE ()-[r:T {prop: 42}]->() DELETE r RETURN r"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher entryFieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("r")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after")))}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])this.bytes(0, 11, 177, 113, 145, 181, 82, 0, 0, 1, 129, 84, 160, 0, 0)));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldNotLeakStatsToNextStatement() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("CREATE (n)"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        Matcher typeMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"type"), (Matcher)CoreMatchers.equalTo((Object)"r"));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)typeMatcher, (Matcher)Matchers.hasKey((Object)"result_consumed_after")))}));
    }

    @Test
    public void shouldSendNotifications() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.hasNotification((Notification)new TestNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, new InputPosition(17, 1, 18)))}));
    }

    @Test
    public void shouldFailNicelyOnPointsWhenProtocolDoesNotSupportThem() throws Throwable {
        Assume.assumeThat((Object)this.neo4jPack.version(), (Matcher)CoreMatchers.equalTo((Object)1L));
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("RETURN point({x:13, y:37, crs:'cartesian'}) as p"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        Matcher fieldsMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("p")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)fieldsMatcher, (Matcher)Matchers.hasKey((Object)"result_available_after"))), MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Point is not supported as a return type in Bolt")}));
    }

    private byte[] bytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Test
    public void shouldFailNicelyOnNullKeysInMap() throws Throwable {
        HashMap params = new HashMap();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        inner.put(null, 42L);
        inner.put("foo", 1337L);
        params.put("p", inner);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("RETURN {p}", ValueUtils.asMapValue(params)), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string."), MessageMatchers.msgIgnored()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{AckFailureMessage.INSTANCE, new RunMessage("RETURN 1"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)Values.longValue((long)1L))})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldFailNicelyWhenDroppingUnknownIndex() throws Throwable {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{new InitMessage("TestClient/1.1", Collections.emptyMap()), new RunMessage("DROP INDEX on :Movie12345(id)"), PullAllMessage.INSTANCE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgFailure((Status)Status.Schema.IndexDropFailed, (String)"Unable to drop index on :Movie12345(id): No such INDEX ON :Movie12345(id)."), MessageMatchers.msgIgnored()}));
    }
}

