/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.function.Factory;
import org.neo4j.kernel.configuration.BoltConnector;

@RunWith(value=Parameterized.class)
public class RejectTransportEncryptionIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> {
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").encryption_level.name(), BoltConnector.EncryptionLevel.DISABLED.name());
    });
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public Factory<TransportConnection> cf;
    @Parameterized.Parameter(value=1)
    public Matcher<String> exceptionMessageMatcher;
    private TransportConnection client;
    private TransportTestUtil util;

    @Parameterized.Parameters
    public static Collection<Object[]> transports() {
        return Arrays.asList({SecureWebSocketConnection::new, StringContains.containsString((String)"Failed to connect to the server within 10 seconds")}, {SecureSocketConnection::new, AnyOf.anyOf((Matcher)StringContains.containsString((String)"Remote host terminated the handshake"), (Matcher)StringContains.containsString((String)"Remote host closed connection during handshake"))});
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV1());
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @Test
    public void shouldRejectConnectionAfterHandshake() throws Throwable {
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage(this.exceptionMessageMatcher);
        this.client.connect(this.server.lookupDefaultConnector()).send(this.util.acceptedVersions(1L, 0L, 0L, 0L));
    }
}

