/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.udc.UsageData;

public class SessionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private GraphDatabaseAPI gdb;
    private BoltStateMachineFactoryImpl boltFactory;
    private List<BoltStateMachine> runningMachines = new ArrayList<BoltStateMachine>();
    private boolean authEnabled;

    private Authentication authentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        return new BasicAuthentication(authManager, userManagerSupplier);
    }

    public BoltStateMachine newMachine(long version, BoltChannel boltChannel) {
        if (this.boltFactory == null) {
            throw new IllegalStateException("Cannot access test environment before test is running.");
        }
        BoltStateMachine machine = this.boltFactory.newStateMachine(version, boltChannel);
        this.runningMachines.add(machine);
        return machine;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        HashMap<Setting, String> config = new HashMap<Setting, String>();
        config.put(GraphDatabaseSettings.auth_enabled, Boolean.toString(this.authEnabled));
        this.gdb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase(config);
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        Authentication authentication = this.authentication((AuthManager)resolver.resolveDependency(AuthManager.class), (UserManagerSupplier)resolver.resolveDependency(UserManagerSupplier.class));
        this.boltFactory = new BoltStateMachineFactoryImpl((DatabaseManager)resolver.resolveDependency(DatabaseManager.class), new UsageData(null), authentication, Clock.systemUTC(), Config.defaults(), (LogService)NullLogService.getInstance());
    }

    public void afterEach(ExtensionContext extensionContext) {
        try {
            if (this.runningMachines != null) {
                IOUtils.closeAll(this.runningMachines);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.gdb.shutdown();
    }
}

