/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.Collections;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailedState;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.StreamingState;
import org.neo4j.bolt.v3.runtime.TransactionReadyState;
import org.neo4j.bolt.v3.runtime.integration.BoltStateMachineStateTestBase;
import org.neo4j.kernel.api.exceptions.Status;

class ReadyStateIT
extends BoltStateMachineStateTestBase {
    ReadyStateIT() {
    }

    @Test
    void shouldMoveToStreamingOnRun_succ() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeeded());
        Assertions.assertTrue((boolean)response.hasMetadata("fields"));
        Assertions.assertTrue((boolean)response.hasMetadata("t_first"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(StreamingState.class));
    }

    @Test
    void shouldMoveToStreamingOnBegin_succ() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionReadyState.class));
    }

    @Test
    void shouldMoveToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    @Test
    void shouldMoveToFailedStateOnRun_fail() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process((RequestMessage)runMessage, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
    }

    @Test
    void shouldMoveToFailedStateOnBegin_fail() throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BeginMessage beginMessage = (BeginMessage)Mockito.mock(BeginMessage.class);
        Mockito.when((Object)beginMessage.bookmark()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process((RequestMessage)beginMessage, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV2Messages"})
    void shouldCloseConnectionOnIllegalV2Messages(RequestMessage message) throws Throwable {
        this.shouldCloseConnectionOnIllegalMessages(message);
    }

    private void shouldCloseConnectionOnIllegalMessages(RequestMessage message) throws InterruptedException, BoltConnectionFatality {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)ReadyStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
        Assertions.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() {
        return Stream.of(ReadyStateIT.newHelloMessage(), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE, CommitMessage.COMMIT_MESSAGE, RollbackMessage.ROLLBACK_MESSAGE, GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private static Stream<RequestMessage> illegalV2Messages() {
        return Stream.of(new InitMessage("BoltConnectionIT/0.0", Collections.emptyMap()), new org.neo4j.bolt.v1.messaging.request.RunMessage("RETURN 1", EMPTY_PARAMS));
    }
}

