/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.integration.BoltV3TransportBase;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GoodbyeMessageIT
extends BoltV3TransportBase {
    @Test
    public void shouldCloseConnectionInConnected() throws Throwable {
        this.connection.connect(this.address).send(this.util.acceptedVersions(3L, 2L, 1L, 0L));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInReady() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInStreaming() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")}));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"t_first")))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
        MatcherAssert.assertThat((Object)this.server, GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldCloseConnectionInFailed() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new RunMessage("I am sending you to failed state!")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgFailure((Status)Status.Statement.SyntaxError, (String)String.format("Invalid input 'I': expected <init> (line 1, column 1 (offset: 0))%n\"I am sending you to failed state!\"%n ^", new Object[0]))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
    }

    @Test
    public void shouldCloseConnectionInTxReady() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage()}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
        MatcherAssert.assertThat((Object)this.server, GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldCloseConnectionInTxStreaming() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{new BeginMessage(), new RunMessage("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")}));
        Matcher entryFieldMatcher = Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "a_squared")));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)entryFieldMatcher, (Matcher)Matchers.hasKey((Object)"t_first")))}));
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
        MatcherAssert.assertThat((Object)this.server, GoodbyeMessageIT.eventuallyClosesTransaction());
    }

    @Test
    public void shouldDropConnectionImmediatelyAfterGoodbye() throws Throwable {
        this.negotiateBoltV3();
        this.connection.send(this.util.chunk(new RequestMessage[]{GoodbyeMessage.GOODBYE_MESSAGE, ResetMessage.INSTANCE, new RunMessage("RETURN 1")}));
        MatcherAssert.assertThat((Object)this.connection, (Matcher)TransportTestUtil.serverImmediatelyDisconnects());
    }

    private static Matcher<Neo4jWithSocket> eventuallyClosesTransaction() {
        return new TypeSafeMatcher<Neo4jWithSocket>(){

            public void describeTo(Description description) {
                description.appendText("Eventually close all transactions");
            }

            protected boolean matchesSafely(Neo4jWithSocket server) {
                BooleanSupplier condition = () -> this.getActiveTransactions(server).size() == 0;
                try {
                    Predicates.await((BooleanSupplier)condition, (long)2L, (TimeUnit)TimeUnit.SECONDS);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            private Set<KernelTransactionHandle> getActiveTransactions(Neo4jWithSocket server) {
                GraphDatabaseAPI gdb = (GraphDatabaseAPI)server.graphDatabaseService();
                return ((KernelTransactions)gdb.getDependencyResolver().resolveDependency(KernelTransactions.class)).activeTransactions();
            }
        };
    }
}

