/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.integration;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailedState;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v3.runtime.TransactionReadyState;
import org.neo4j.bolt.v3.runtime.TransactionStreamingState;
import org.neo4j.bolt.v3.runtime.integration.BoltStateMachineStateTestBase;
import org.neo4j.kernel.api.exceptions.Status;

class TransactionStreamingStateIT
extends BoltStateMachineStateTestBase {
    TransactionStreamingStateIT() {
    }

    @Test
    void shouldMoveFromTxStreamingToTxReadyOnDiscardAll_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeeded());
        Assert.assertFalse((boolean)response.hasMetadata("bookmark"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionReadyState.class));
    }

    @Test
    void shouldMoveFromTxStreamingToTxReadyOnPullAll_succ() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)PullAllMessage.INSTANCE, (BoltResponseHandler)recorder);
        RecordedBoltResponse response = recorder.nextResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)BoltMatchers.succeeded());
        Assertions.assertTrue((boolean)response.hasMetadata("type"));
        Assertions.assertTrue((boolean)response.hasMetadata("t_last"));
        Assert.assertFalse((boolean)response.hasMetadata("bookmark"));
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionReadyState.class));
    }

    @Test
    void shouldMoveFromTxStreamingToInterruptedOnInterrupt() throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxStreamingState();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)InterruptSignal.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(InterruptedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"pullAllDiscardAllMessages"})
    void shouldMoveFromTxStreamingStateToFailedStateOnPullAllOrDiscardAll_fail(RequestMessage message) throws Throwable {
        BoltStateMachineV3 machine = this.getBoltStateMachineInTxStreamingState();
        BoltResponseHandler handler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        machine.process(message, handler);
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(FailedState.class));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV3Messages"})
    void shouldCloseConnectionOnIllegalV3MessagesInTxStreamingState(RequestMessage message) throws Throwable {
        this.shouldThrowExceptionOnIllegalMessagesInTxStreamingState(message);
    }

    private void shouldThrowExceptionOnIllegalMessagesInTxStreamingState(RequestMessage message) throws Throwable {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)TransactionStreamingStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionStreamingState.class));
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltMatchers.verifyKillsConnection(() -> machine.process(message, (BoltResponseHandler)recorder));
        MatcherAssert.assertThat((Object)recorder.nextResponse(), (Matcher)BoltMatchers.failedWithStatus((Status)Status.Request.Invalid));
        Assert.assertNull((Object)machine.state());
    }

    private static Stream<RequestMessage> illegalV3Messages() throws BoltIOException {
        return Stream.of(TransactionStreamingStateIT.newHelloMessage(), new RunMessage("any string"), new BeginMessage(), RollbackMessage.ROLLBACK_MESSAGE, CommitMessage.COMMIT_MESSAGE, ResetMessage.INSTANCE, GoodbyeMessage.GOODBYE_MESSAGE);
    }

    private static Stream<RequestMessage> pullAllDiscardAllMessages() {
        return Stream.of(PullAllMessage.INSTANCE, DiscardAllMessage.INSTANCE);
    }

    private BoltStateMachineV3 getBoltStateMachineInTxStreamingState() throws BoltConnectionFatality, BoltIOException {
        BoltStateMachineV3 machine = this.newStateMachine();
        machine.process((RequestMessage)TransactionStreamingStateIT.newHelloMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionReadyState.class));
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine.state(), (Matcher)CoreMatchers.instanceOf(TransactionStreamingState.class));
        return machine;
    }
}

