/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.bolt.runtime.scheduling.BoltConnectionReadLimiter;
import org.neo4j.bolt.testing.MessageMatchers;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.AnyValue;

public class BoltChannelAutoReadLimiterIT {
    private AssertableLogProvider logProvider;
    private EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), (Supplier)this.fsRule, this.getSettingsFunction());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.server);
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    protected TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder();
        this.logProvider = new AssertableLogProvider();
        factory.setInternalLogProvider((LogProvider)this.logProvider);
        return factory;
    }

    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled, false);
    }

    @Before
    public void setup() throws Exception {
        BoltChannelAutoReadLimiterIT.installSleepProcedure(this.server.graphDatabaseService());
        this.address = this.server.lookupDefaultConnector();
        this.connection = new SocketConnection();
        this.util = new TransportTestUtil();
    }

    @Test
    public void largeNumberOfSlowRunningJobsShouldChangeAutoReadState() throws Exception {
        int i;
        int numberOfRunDiscardPairs = 1000;
        String largeString = StringUtils.repeat((String)" ", (int)8192);
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions()).send(this.util.defaultAuth());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
        MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess()}));
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            this.connection.send(this.util.defaultRunAutoCommitTxWithoutResult("CALL boltissue.sleep( $data )", ValueUtils.asMapValue(Collections.singletonMap("data", largeString))));
        }
        for (i = 0; i < numberOfRunDiscardPairs; ++i) {
            MatcherAssert.assertThat((Object)this.connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        }
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltConnectionReadLimiter.class).warn(CoreMatchers.containsString((String)"disabled"), new Object[]{CoreMatchers.anything(), CoreMatchers.anything()})});
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltConnectionReadLimiter.class).warn(CoreMatchers.containsString((String)"enabled"), new Object[]{CoreMatchers.anything(), CoreMatchers.anything()})});
    }

    private static void installSleepProcedure(GraphDatabaseService db) throws ProcedureException {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        ((GlobalProcedures)dbApi.getDependencyResolver().resolveDependency(GlobalProcedures.class)).register((CallableProcedure)new CallableProcedure.BasicProcedure(ProcedureSignature.procedureSignature((String[])new String[]{"boltissue", "sleep"}).in("data", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out(ProcedureSignature.VOID).build()){

            public RawIterator<AnyValue[], ProcedureException> apply(Context context, AnyValue[] objects, ResourceTracker resourceTracker) throws ProcedureException {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Interrupted", new Object[0]);
                }
                return RawIterator.empty();
            }
        });
    }
}

